# Run on remote computers
#Invoke-Command -FilePath e:\etc\WindowsEventLogs.ps1 -ComputerName localhost,rds,ts1,ts2,ts3,ts4

# All that contain info
#Get-WinEvent -ListLog * -ErrorAction Ignore | Where-Object RecordCount -gt 0 | Sort-Object -Property RecordCount -Descending

# List specific ones
#Get-WinEvent -ListProvider *Update*

# Logs to extract from server
#$logArray = @("System","Security","Application","Setup",                   `
#"Microsoft-Windows-TerminalServices-ServerUSBDevices/Operational",         `
#"Microsoft-Windows-TerminalServices-ServerUSBDevices/Admin",               `
#"Microsoft-Windows-TerminalServices-RemoteConnectionManager/Operational",  `
#"Microsoft-Windows-TerminalServices-RemoteConnectionManager/Admin",        `
#"Microsoft-Windows-TerminalServices-RDPClient/Operational",                `
#"Microsoft-Windows-TerminalServices-Printers/Operational",                 `
#"Microsoft-Windows-TerminalServices-Printers/Admin",                       `
#"Microsoft-Windows-TerminalServices-PnPDevices/Operational",               `
#"Microsoft-Windows-TerminalServices-PnPDevices/Admin",                     `
#"Microsoft-Windows-TerminalServices-LocalSessionManager/Operational",      `
#"Microsoft-Windows-TerminalServices-LocalSessionManager/Admin",            `
#"Microsoft-Windows-TerminalServices-ClientUSBDevices/Operational",         `
#"Microsoft-Windows-TerminalServices-ClientUSBDevices/Admin",               `
#"Microsoft-Windows-RemoteDesktopServices-SessionServices/Operational",     `
#"Microsoft-Windows-RemoteDesktopServices-RemoteFX-Synth3dvsc/Admin",       `
#"Microsoft-Windows-RemoteDesktopServices-RdpCoreTS/Operational",           `
#"Microsoft-Windows-RemoteDesktopServices-RdpCoreTS/Admin",                 `
#"Microsoft-Windows-RemoteAppandDesktopConnections/Operational",            `
#"Microsoft-Windows-RemoteAppandDesktopConnections/Admin",                  `
#"ForwardedEvents"                                                          `
#)

#$logArray = @(Get-WinEvent -ListLog * -ErrorAction Ignore | Where-Object RecordCount -gt 0 | Select-Object LogName) |  | Join-String -DoubleQuote
$logArray = @(Get-WinEvent -ListLog * -ErrorAction Ignore | Where-Object RecordCount -gt 0).LogName

# Grabs the server name to append to the log file extraction
$servername = $env:computername

# Provide the path with ending "\" to store the log file extraction.
$destinationpath = "C:\WindowsEventLogs\"

# Checks the last character of the destination path.  If it does not end in '\' it adds one.
# '.+?\\$' +? means any character \\ is looking for the backslash $ is the end of the line charater
if ($destinationpath -notmatch '.+?\\$')
{
    $destinationpath += '\'
}

# If the destination path does not exist it will create it
if (!(Test-Path -Path $destinationpath))
{
    New-Item -ItemType directory -Path $destinationpath
}

# Get the current date in YearMonthDay format
$logdate = Get-Date -format yyyyMMddHHmm

# Start Process Timer
$StopWatch = [system.diagnostics.stopwatch]::startNew()

# Start Code
Clear-Host

Foreach($log in $logArray)
{
    # If using Clear and backup
    $destination = $destinationpath + $servername + "-" + $log.replace("/","_") + "-" + $logdate + ".evtx"
	$destination = $destinationpath + $servername + "-" + $log.replace("/","_")                  + ".evtx"

    Write-Host "Extracting the $log file now."

    # Extract each log file listed in $logArray from the local server.
    wevtutil epl "$log" "$destination"

    # Write-Host "Clearing the $log file now."

    # Clear the log and backup to file.
    # WevtUtil cl $log

}

# End Code

# Stop Timer
$StopWatch.Stop()
$TotalTime = $StopWatch.Elapsed.TotalSeconds
$TotalTime = [math]::Round($totalTime, 2)
write-host "The Script took $TotalTime seconds to execute."