function _Log {
    param([Parameter(Mandatory=$true)][string]$Message)
    Write-Output "[$(Get-Date)] $Message"
}
function PveChocoInstall {
    _Log 'The Chocolatey installer starts.' 
    $installSleep = 5
    $SecurityProtocol = [Net.SecurityProtocolType]::Tls12;[Net.ServicePointManager]::SecurityProtocol = $SecurityProtocol;[System.Net.ServicePointManager]::SecurityProtocol = 3072;
    $installScriptUrl = 'https://chocolatey.org/install.ps1'
    $chocolateyBinPath = "$env:ALLUSERSPROFILE\chocolatey\bin"
    $PATH = "$env:PATH;$chocolateyBinPath"
    Set-Variable "PATH=$PATH"
    Invoke-WebRequest $installScriptUrl -UseBasicParsing | Invoke-Expression 
    Invoke-Expression ((New-Object System.Net.WebClient).DownloadString($installScriptUrl));
    refreshenv
    choco feature enable -n=allowGlobalConfirmation
    choco feature enable -n=allowEmptyChecksums
    Start-Sleep $installSleep
    choco install -y pswindowsupdate
    _Log 'The Chocolatey installer finished.'
}
function PveChocoInstallVirtio {
    $virtioVersion = 0.1.208 # 0.1.215.200
    _Log 'The Virtio installer starts.' 
    #choco install -y virtio-drivers   --version=$virtioVersion --force
    #choco install -y qemu-guest-agent --version=$virtioVersion --force
    choco install -y virtio-drivers    --version=$virtioVersion --force
    choco pin add -n virtio-drivers
    #choco pin add -n qemu-guest-agent
    _Log 'The Virtio installer finished.'
}
function PveWinupInstall {
    _Log 'The windows updates installer starts.' 
	[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
    Install-Module           PowerShellGet -Force
    Update-Module           -Name PowerShellGet -Force
	Install-PackageProvider -Name NuGet -Force
	Import-PackageProvider  -Name NuGet
	Set-PSRepository        -Name PSGallery -InstallationPolicy Trusted
	Install-Module          -Name PSWindowsUpdate -Force
	Import-Module           -Name PSWindowsUpdate
	$MicrosoftUpdateServiceId = "7971f918-a847-4430-9279-4a52d1efe18d"
	If   ((Get-WUServiceManager -ServiceID $MicrosoftUpdateServiceId).ServiceID -eq $MicrosoftUpdateServiceId)  { Write-Output "Confirmed that Microsoft Update Service is registered..." } Else { Add-WUServiceManager -ServiceID $MicrosoftUpdateServiceId -Confirm:$true }
	If (!((Get-WUServiceManager -ServiceID $MicrosoftUpdateServiceId).ServiceID -eq $MicrosoftUpdateServiceId)) { Throw "ERROR:  Microsoft Update Service is not registered." }
	Get-WUSettings
    _Log 'The windows updates installer finished.'
}
function PveWinRebootNow {
    _Log 'RebootNow' 
	Restart-Computer -Force
}
function PveWinShutdownNow {
    _Log 'ShutdownNow' 
	Stop-Computer -Force
}
function PveWinShutdown { 
    param(
        [string]$TaskName,
        [string]$TaskOption,
        [string]$TaskTimeout,
        [string]$TaskDateTime
    )
    _Log 'PveWinShutdown started' 
	$taskDescription = $taskName
    $doUpdate = if ($args -contains "-DoUpdate") {"Get-WUInstall -MicrosoftUpdate -AcceptAll -Download -Install -IgnoreReboot"}
	$taskCommand     = "$doUpdate;shutdown $TaskOption -t $TaskTimeout;schtasks.exe /delete /f /tn $taskName;"
	$action          = New-ScheduledTaskAction `
		-Execute     'C:\Windows\System32\WindowsPowerShell\v1.0\powershell.exe' `
		-Argument    "-NoProfile -NoLogo -NonInteractive -ExecutionPolicy Bypass -Command `"$taskCommand`""
	$trigger         = New-ScheduledTaskTrigger -Once -At $TaskDateTime
	$taskSettings    = New-ScheduledTaskSettingsSet -Compatibility Win8
	Register-ScheduledTask `
		-Force `
		-User        "SYSTEM" `
		-TaskName    $taskName `
		-Action      $action `
		-Trigger     $trigger `
		-Settings    $taskSettings `
		-Description $taskDescription
    _Log 'PveWinShutdown finished.'
}

function PveWinCleanupNow {
    _Log 'Cleanup started.' 
    Invoke-Expression "dism /online /cleanup-image /restorehealth"
    Invoke-Expression "dism /online /cleanup-image /startcomponentcleanup /resetbase"
    Invoke-Expression "sfc /scannow"
    Invoke-Expression "echo y|chkdsk /x /f /r;echo j|chkdsk /x /f /r;"
    #Invoke-Expression "shutdown -r -t 1"
    #Invoke-Expression "shutdown -r -s 1"
    _Log 'Cleanup finished.'
}
refreshenv
#Clear-Host

