## CONF 
 
#https://openzfs.github.io/openzfs-docs/Performance%20and%20Tuning/Module%20Parameters.html?highlight=txg#zfs-module-parameters-1 
#https://openzfs.github.io/openzfs-docs/search.html?q= 
 
conf="/etc/modprobe.d/zfs.conf";op="options zfs";cat $conf; 
zfs_arc_min=8                     ;((zfs_arc_min=$zfs_arc_min*1024*1024*1024))                      ;zfs_arc_min="$op zfs_arc_min=$zfs_arc_min"                                 ;echo $zfs_arc_min >$conf; 
zfs_arc_max=32                    ;((zfs_arc_max=$zfs_arc_max*1024*1024*1024))                      ;zfs_arc_max="$op zfs_arc_max=$zfs_arc_max"                                 ;echo $zfs_arc_max>>$conf; 
zfs_dirty_data_max=2              ;((zfs_dirty_data_max=$zfs_dirty_data_max*1024*1024*1024))        ;zfs_dirty_data_max="$op zfs_dirty_data_max=$zfs_dirty_data_max"            ;echo $zfs_dirty_data_max>>$conf; 
zfs_dirty_data_max_max=4          ;((zfs_dirty_data_max_max=$zfs_dirty_data_max_max*1024*1024*1024));zfs_dirty_data_max_max="$op zfs_dirty_data_max_max=$zfs_dirty_data_max_max";echo $zfs_dirty_data_max_max>>$conf; 
zfs_dirty_data_max_max_percent=25 ;echo "$op ""zfs_dirty_data_max_max_percent=""$zfs_dirty_data_max_max_percent">>$conf; 
zfs_dirty_data_max_percent=10     ;echo "$op ""zfs_dirty_data_max_percent=""$zfs_dirty_data_max_percent">>$conf; 
zfs_dirty_data_sync_percent=20    ;echo "$op ""zfs_dirty_data_sync_percent=""$zfs_dirty_data_sync_percent">>$conf; 
zfs_arc_dnode_limit=0             ;echo "$op ""zfs_arc_dnode_limit=""$zfs_arc_dnode_limit">>$conf; 
zfs_arc_dnode_limit_percent=50    ;echo "$op ""zfs_arc_dnode_limit_percent=""$zfs_arc_dnode_limit_percent">>$conf; 
zfs_arc_meta_limit=0              ;echo "$op ""zfs_arc_meta_limit=""$zfs_arc_meta_limit">>$conf; 
zfs_arc_meta_limit_percent=95     ;echo "$op ""zfs_arc_meta_limit_percent=""$zfs_arc_meta_limit_percent">>$conf; 
zfs_prefetch_disable=1            ;echo "$op ""zfs_prefetch_disable=""$zfs_prefetch_disable">>$conf; 
zfs_nocacheflush=1                ;echo "$op ""zfs_nocacheflush=""$zfs_nocacheflush">>$conf; 
zfs_vdev_sync_write_min_active=8  ;echo "$op ""zfs_vdev_sync_write_min_active=""$zfs_vdev_sync_write_min_active">>$conf; 
zfs_vdev_sync_write_max_active=32 ;echo "$op ""zfs_vdev_sync_write_max_active=""$zfs_vdev_sync_write_max_active">>$conf; 
zfs_vdev_sync_read_min_active=8   ;echo "$op ""zfs_vdev_sync_read_min_active=""$zfs_vdev_sync_read_min_active">>$conf; 
zfs_vdev_sync_read_max_active=32  ;echo "$op ""zfs_vdev_sync_read_max_active=""$zfs_vdev_sync_read_max_active">>$conf; 
zfs_vdev_async_read_min_active=8  ;echo "$op ""zfs_vdev_async_read_min_active=""$zfs_vdev_async_read_min_active">>$conf; 
zfs_vdev_async_read_max_active=32 ;echo "$op ""zfs_vdev_async_read_max_active=""$zfs_vdev_async_read_max_active">>$conf; 
zfs_vdev_async_write_min_active=8 ;echo "$op ""zfs_vdev_async_write_min_active=""$zfs_vdev_async_write_min_active">>$conf; 
zfs_vdev_async_write_max_active=32;echo "$op ""zfs_vdev_async_write_max_active=""$zfs_vdev_async_write_max_active">>$conf; 
zfs_txg_timeout=5                 ;echo "$op ""zfs_txg_timeout=""$zfs_txg_timeout">>$conf; 
 
cat $conf; 
update-grub && update-initramfs -u -k all; 
 
## DISKS 
 
SSD_A="/dev/disk/by-id/scsi-3600605b00ca321a02b21ccb430e0158c" 
SSD_B="/dev/disk/by-id/scsi-3600605b00ca321a02b21cc702cd04f63" 
SSD_C="/dev/disk/by-id/scsi-3600605b00ca321a02b21cc2e28e2e22f" 
SSD_D="/dev/disk/by-id/scsi-3600605b00ca321a02b21cbe824b1c334" 
SSD_E="/dev/disk/by-id/scsi-3600605b00ca321a02b21cba2208e21db" 
SSD_F="/dev/disk/by-id/scsi-3600605b00ca321a02b21cb601ca18dca" 
 
cat << EOF > /etc/zfs/vdev_id.conf
alias SSD_A_58c scsi-3600605b00ca321a02b21ccb430e0158c-part1 
alias SSD_B_f63 scsi-3600605b00ca321a02b21cc702cd04f63-part1 
alias SSD_C_22f scsi-3600605b00ca321a02b21cc2e28e2e22f-part1 
alias SSD_D_334 scsi-3600605b00ca321a02b21cbe824b1c334-part1
alias SSD_E_1db scsi-3600605b00ca321a02b21cba2208e21db-part1
alias SSD_F_dca scsi-3600605b00ca321a02b21cb601ca18dca-part1
EOF
 
udevadm trigger 
 
## PARTITION 
 
parted $SSD_A --script -- mklabel gpt 
parted $SSD_B --script -- mklabel gpt 
parted $SSD_C --script -- mklabel gpt 
parted $SSD_D --script -- mklabel gpt 
parted $SSD_E --script -- mklabel gpt 
parted $SSD_F --script -- mklabel gpt 
 
## POOL 
 
pool=zfs 
 zpool create -f $pool -o ashift=12 -o autotrim=on raidz $SSD_A $SSD_B $SSD_C $SSD_D $SSD_E $SSD_F
zfs get recordsize,xattr,compression,sync,atime,relatime,dedup,logbias,primarycache,secondarycache $pool #pool=zfs; zpool create -f $pool -o ashift=0 -o xattr=on -o sync=standard -o compression=off -o atime=on  -o relatime=off -o recordsize=128K dedup=off -o logbias=latency -o primarycache=all -o secondarycache=all -o keyformat=none -o sharesmb=off -o sharenfs=off -o mountpoint=/zfs -o altroot= \ 
 
 pveperf /zfs 
 zfs set recordsize=128K       $pool 
 zfs set xattr=sa              $pool 
 zfs set sync=disabled         $pool 
 zfs set compression=lz4       $pool 
 zfs set atime=off             $pool 
 zfs set relatime=on           $pool 
 zfs set dedup=off             $pool 
 zfs set logbias=throughput    $pool 
 zfs set primarycache=metadata $pool 
 zfs set secondarycache=none   $pool 
#zfs set sharesmb=off          $pool 
#zfs set sharenfs=off          $pool 
#zfs set volblocksize=16K      $pool 
#zfs set keyformat=raw         $pool 
 pveperf /zfs 
 
zpool set autotrim=on             $pool 
zpool export                      $pool 
zpool import -d /dev/disk/by-vdev $pool 
#zpool import -c /etc/$pool/zpool.cache -aN 
 
## STORAGE 
 
pvesm add zfspool $pool -pool $pool -blocksize 16K -content rootdir,images -mountpoint /zfs -nodes pve021 -sparse 1
