#shutdown vm and make sure there is no snapshots
#run veeam backup task
#run veeam replica task when backup task finished
#set parameters for migration to proxmox
esx="pve3k";esxRep="pve3k";pve="pve6k";esxRoot="/mnt/sshfs/$esx";clone="100000002";netapp="SAN01DS02";vm="dcdusfs1";dsm="DSM2RW";rep=$vm"_v2p";id="17001031";
#mount sshfs to retrieve vm info
mkdir -p $esxRoot;mkdir -p /mnt/sshfs/$esxRep;
sshfs -o allow_other,default_permissions root@$esx:/vmfs/volumes/ $esxRoot;sshfs -o allow_other,default_permissions root@$esxRep:/vmfs/volumes/ /mnt/sshfs/$esxRep;
#remove snapshots on the replica (when you do it, veeam replica will calculate digests again, which will take time)
repId=$(ssh root@$esxRep "vim-cmd vmsvc/getallvms | grep $rep" | awk -F ' ' '{print $1}');echo $repId;
ssh root@$esxRep "vim-cmd vmsvc/snapshot.get $repId;vim-cmd vmsvc/snapshot.removeall $repId";
#collect some info of the source vm
sourceRoot="$esxRoot/$netapp/$vm";echo "$sourceRoot";
cat    $sourceRoot/$vm*.vmx |grep 'vmdk"'       |sort
#scsi0:0.fileName = "dcdusfs1.vmdk"
#scsi0:1.fileName = "dcdusfs1_1.vmdk"
ls -lh $sourceRoot/$vm*.vmdk                     
cat    $sourceRoot/$vm*.vmx |grep '.ddress = ' |sort
#collect some info of the clone
repRoot="/mnt/sshfs/$esxRep/$dsm/$rep";
cat    $repRoot/$vm*.vmx |grep 'vmdk"'          |sort
#scsi0:0.fileName = "dcdusfs1.vmdk"
#scsi0:1.fileName = "dcdusfs1_1.vmdk"
ls -lh $repRoot/$vm*.vmdk
cat    $repRoot/$vm*.vmx |grep '.ddress = '    |sort
#set replica parameters
vmDisk1=`cat $repRoot/$vm*.vmx    |grep 'dcdusfs1.vmdk"'    | cut -d \" -f2`;echo $vmDisk1;vmDisk1="/mnt/pve/dsm2/vcenter/$rep/$vmDisk1";ls -lah $vmDisk1;echo "[vmDisk1=$vmDisk1]";
vmDisk2=`cat $repRoot/$vm*.vmx    |grep 'dcdusfs1_1.vmdk"'  | cut -d \" -f2`;echo $vmDisk2;vmDisk2="/mnt/pve/dsm2/vcenter/$rep/$vmDisk2";ls -lah $vmDisk2;echo "[vmDisk2=$vmDisk2]";
 vmMac1=`cat $sourceRoot/$vm*.vmx |grep ".ddress" | grep ':' | cut -d \" -f2`;echo $vmMac1;echo "[vmMac1=$vmMac1]";
 vmconf="/etc/pve/nodes/$pve/qemu-server/$id.conf";
#clone template, update mac & bridge, import disk, update disk, add fake virtio, update boot order, then start the vm
qm guest cmd    $id ping || {
 pvesh create /nodes/$pve/qemu/$clone/clone --newid $id --name $vm --full true
 qm set          $id --net0 virtio="$vmMac1",bridge=vmbr99;
}
qm guest cmd     $id ping || {
 sleep 15m
 date >>/tmp/$id.log;qm importdisk $id $vmDisk1 zfs --format raw;date >>/tmp/$id.log && cat /tmp/$id.log
 date >>/tmp/$id.log;qm importdisk $id $vmDisk2 zfs --format raw;date >>/tmp/$id.log && cat /tmp/$id.log
}
qm guest cmd     $id ping || {
#pvesh get    /nodes/$pve/qemu/$id/config  --output-format json | jq -r 'first(to_entries[]|select(.key|startswith("unused"))).value'
#pvesh get    /nodes/$pve/qemu/$id/config  --output-format json | jq -r 'last(to_entries[]|select(.key|startswith("unused"))).value'
 qm set          $id --sata0 zfs:vm-$id-disk-0
 qm set          $id --sata1 zfs:vm-$id-disk-1
#qm importdisk   $id /mnt/pve/dsm1/images/disk.raw zfs --format raw
#qm set          $id --virtio0  zfs:vm-$id-disk-1
 pvesm alloc zfs $id "vm-$id-disk-15" 1M
 qm set          $id --virtio15 zfs:vm-$id-disk-15
 sed -i '/boot:/d' "$vmconf"
 echo 'boot: order=sata0'>>"$vmconf"
 qm rescan --vm  $id
}   && qm start  $id
#login to vm and update settings
 qm guest cmd  $id ping && {
 qm guest cmd  $id network-get-interfaces
 qm guest exec $id cmd -- "/c ipconfig /all"
 qm guest exec $id powershell -- "c:\tools\pve\scripts\removeGhosts.ps1;"
 qm guest exec $id powershell -- "c:\tools\pve\scripts\removeVmwareTools.ps1;"
 qm guest exec $id powershell -- "c:\tools\pve\scripts\setNetworkConfig.ps1;"
 qm guest exec $id powershell -- "Stop-Computer;"
}
#review config and update settings
#X:\sync\onedrive\iSystems Consulting e.K\iSystems Support - SAP\EMEA\Customers\Part\Kluthe\20220705\EnableSnmp.sh
#X:\sync\onedrive\iSystems Consulting e.K\iSystems Support - SAP\EMEA\Customers\Part\Kluthe\20220705\HanaOnKvm.sh
#delete fake virtio, attach disk as virtio, enable network, update boot order
qm guest cmd $id ping || { 
 qm set $id -agent 1,fstrim_cloned_disks=1
 qm set $id -balloon 2048
 qm set $id -memory 8192
 qm set $id -sockets 2
 qm set $id -cores 2
 qm set $id -cpu kvm64
 qm set $id -numa 1
 qm set $id -vga std
 qm set $id -delete virtio15
 qm set $id -delete unused0
 qm set $id -scsihw virtio-scsi-single
 qm set $id -delete sata0;qm set $id -virtio0 zfs:vm-$id-disk-0,discard=on,aio=native,iothread=1,mbps_rd=256,mbps_wr=256
 qm set $id -delete sata1;qm set $id -virtio1 zfs:vm-$id-disk-1,discard=on,aio=native,iothread=1,mbps_rd=256,mbps_wr=256
 qm set $id -net0 virtio="$vmMac1",bridge=vmbr0
#qm set $id -delete shares,onboot,spice_enhancements
 sed -i '/boot:/d' "$vmconf"
 echo 'boot: order=ide0;virtio0'>>"$vmconf"
 qm rescan --vm $id 
 cat "$vmconf"
}   && qm start $id
#do some cleanup if needed and shutdown pc
qm guest cmd  $id ping && {
 qm guest cmd  $id network-get-interfaces
 qm guest exec $id powershell -- "c:\tools\pve\scripts\removeGhosts.ps1;"
 qm guest exec $id powershell -- "c:\tools\pve\scripts\removeVmwareTools.ps1;"
 qm guest exec $id powershell -- "Stop-Computer;"
}
#unregister vm from esxi
#remove vm replica from esxi
#remove vm from replica job
#disable backup/replica jobs
