#NOTES
- [ ] M2,Raid1=32GB,hdsize=24GB,swapsize=8GB
- [ ] SSDs=Raid5,512K,DriveCache=Enabled,Init=Full
- [ ] Storage per NFS einbinden mit Hostname
- [ ] ISO NFS einbinden
- [ ] Backups einrichten mit PBS
- [ ] /etc/hosts editieren
- [ ] Updates Installieren
- [ ] Backup Server Grundconfig
- [ ] 
- [ ] 
- [ ] 
- [ ] 
- [ ] 
- [ ] 
- [ ] 
- [ ] 
- [ ] 
- [ ] 
- [ ] 
- [ ] 



#LINKS
#https://github.com/Corsinvest/awesome-proxmox-ve
#https://github.com/extremeshok/xshok-proxmox
#https://gist.github.com/mrpeardotnet/e6bc57ed899c948ba53b3193a202eb2c
#https://www.hungred.com/how-to/server/list-of-useful-proxmox-command/
#https://gist.github.com/mrpeardotnet/6bdc4b504f43ce57fa7eaee96d376edf#file-pve-host-backup-md
#https://github.com/DerDanilo/proxmox-stuff
#https://cheatography.com/the-iceman-blog/cheat-sheets/zfs-command-line-reference/

#ISO
nfs#192.168.182.71:/iso/proxmox-ve_7.1-1.iso

#SSH
#/home/ansible/files/00-all_keys.txt
cat > /root/.ssh/authorized_keys << __ALLE-KEYS__
ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQDiak2aW6hwqeTs4/+oA/y09AXCjjc4EEKTmOaU0AIXY1OMD/syVz4rHV8VLohcE6tmzjzXZDmDuFSY7XnoBrBJR/ZEfCbQFCpaOQ1VZ7Z/BtRagPkjsZxUpeQ6+VQz8VmsCfxI4nhg19OOk2gBv0/hQD1HGmE2Rcu0JL2l4maZJUnCcCYhsb7j+m9B/jissncI59XjBGUSfIgixId0uUbcpW/Ze67HdhcTaImlra5zC+RPdJJSLfrlyRP+G1sDHNaS/fJXk7oLIOHpQo0zifDUkcWcKlWR201WG8pIjmUsoaBuGO69y/KIqR3fJoWArDD3uKzAqkmC2PoZYa5OWhBd root@HCC-02 
ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQCxo9UZTTksrYaTU8UVHIa6wb5+kpywel5j2kSpkYG9ibb+6zOE+VzchRAm03Gtw7Y5CT9VAQdHpCvaZJn2flxb73vU0gO/acKSRIhINz/QO33bYQnN5gX7D53Vy7TlY259/kHfOvIUGq3BF+lYF4wHrOhEbVMwjCJrH2NQfmmsfPtS6prGJba+dh0FV4K4jkX6fD9vxLST7ulbrssUxF9PcGRVmI0FOYVI2YWBZMaJp1QVLo/vwEQbDH4PCMiMOtBX5C6ot7dUgu2H+nmEeu0LWaQh+JYP3jR7yOfFLD6mkVoAkZDLkljEMJxhC21TZpbtgTf9CeTWEVj0qnIxsxml root@HCC-RZL3-01 
ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQDClquILDs6oqokrkNS4WjKt3mh0rBuXM6VOpjKT5WV3cqiogZ8AP7tHQAIYjEPdkqDi9i7nSLEHsYV8t+Lc7W5A5DBeiSG27Fhf5H/RVbXY1TMmoMpnqAHbFVRiOY1rv9gp7j9Vu7uOYSKnVQnH7dra1N4HdBaGo/uuM3mPZCaOgqLl3RBATb0dU8mTW/eznrb69rYK3gw9U1/u0v6SopPLLBMkYQSx/jadr/L7gAIRa9yu+5sngt4jewAsqC4puU7xunjJndKGnWseYcyOzmYub2p5ce7Gia/j1RbPOF3++vwpiZAfi4clny+Ra8fwlgb9TLU+CS3bVBlBUIlfZjd klaus@Lenovo-P310 
ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQC7c2DfsgOCNSrX8GwwudGGMbmSyigGnv6bM4yCXhbE2wnPhBdF02N2JZxa1URgbaT69Q/U+Gnv7GwC0ZnJUixPcz7eNj3/U9uHstwk7FSxBfAot+M8svSE7kSLoFxf3l99QdbHneNa67K4g2pukbwtjmypChGp7X0f/gixa8VmSvGbIrwAYhZyAvXCPYPY+HFnvVz0z2KR4taq2t5gbBdpW/F/ppV4KpNDZDgkFaFSQ1EKFPWGrsetbwE6vWaPwm+JcH08CgL8fbv9JvMJmPCtkOtluIwsPV6eSLpv81v9digDYmbgYufBmrbmaplHhUaps3iA59tZReH+WVOgQHMf root@Lenovo-P310 
ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQCz2BbQyhA75M+goDLoQeQqhqQkyoYduweOxxndza8dPhCoWIF2tZFie0SPae8TFOspQ0OMHrwxCNyWsUomSxYmRi7u24+gAcV19/ZN3USlGObJ1tscx1QIucUJ2iikNuAo8pu5PpHvRBvqQ13ZZvRXidLTRK60UkQMOPhCviNIRLn9kh5iOI6NxAbaiojPaMdyr5SS0ExUX0PBXpdFcYeLXfBNA4RMyNBC3vWGalEMcbTvQ+KtMY55oSg+69+jhGPccuY2MmwNdP1aFpBxhSuyIu/wa/lD//zHSraY0QgxuTFzw1oTWlvXApeFNT3WJydrpc1TnEvJ6EZiMooDhjet klaus@X349m 
ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQCsDPj4VCKj8Aab8QGDdsL2YEL+eBiKiTzBHFgRfxxd485GtVvfYEM7ElnEVEkjFU1rP6VZcSP/k/13vlkfaMHCs1ep2dmYon7UvXiKd6LTEz1thgDL2OdRVDluL5lTPxCF5LM/wQEbrI31cRs/H2g1GE3TUcC2uYtPnoN6ZDAwdqze2sIFqF/HJPOnStGaQk89IFonvetYSBwxLdqzQ9UE4yHA5vC2nplJ5+Lzifn0wdaYikyMMFgU6iHxeJLwYO9IFVzLtuy/hV11NNCczJhZ78B883aPe6Uz7vVH7PrzFYpRhRMfD/v585wHAaD2ifa4QTGZ2v8EP+Bfdx1RkRxp root@X349m 
ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQCfZuhHrytwVj8SbzDWG+aUhxqyyP1szL1jHUqxmH8SIawLrl3aEpwXFFRxn+NeMlKktuHFBzmp07IQJspYQCE15nqJeUkB8LlMKeV7AyfKrPCDUICo1F6CweEaGduR0LKlyIBlI6uzwvdX7xJ8IvvFXXy1SSXJweecxHxkQvtSFS5uC4ba1VJqPoPTLms1+YyTLB1IFrM18qcu4vJsPrILsq2/x1773THQ2uFVfROwwi0S7HbjwKkeZDuqGtwDcn8LZ+tCsO83tSVyRheImIdDNSatQLJu7fFXp8w6w5H/RvLL5K8ihcwGs35xJ90jh6eOPLhbPxiKgrXVXVAgLK2F root@HMC-01 
ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQDBejZNhe/b5G5osjHujDF/I+l27RBKEK4pso73M4JtyBFD0XpsloifA4b0/AF2p9fjV0pf79rfWmRaAeZl+mKALuaGnUc17CjI0omw977pQLhOVXYQDAC4yhUbk63FaIwyQ49WXKTnzbPC2h+LSWK9aOKBejSdibnM2hYMvnSZg69ckFySTNsto6vC4dYGyy/zttERTyLczE2dsSZy2kdytwurB724EiE6vuBHDYgwp796Mjp4FTDXOg9NPEvqBPhlLDPQ3YaV2pZhzn579O2vxM4XUtXqcx5NckgFgdBUnQupFQVMDlyvlf3GAUl7kt1S8dDNeWrRSpxWFaQWeEXx root@dctpa-hcc-01 
ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQDiCpHdqyjOlGLAjEpYqhH+Hdrd71e6gRxJN3h1DWgubK0ygP2oltEaO5isFnsw31K4oQJly86XaxiWpBDGYuDawiUTWS4HpLMBJROqiUo3sGGis6/1hxJdsA5aBo99mnVedqLWSOzaGf3gEBMMpaUlI6IlHrQYbAB8IEd8AklqGb8eOv/0eGqPdBzTbcWQF93O/2RDux09aMfDcNaCT3i0pVGKE9eG4n/KTdp7FkwRwEPIhCwc3+Y8KX7B4PzIGlGIQ+wLUG94ebTtItgV2C65g/iXSM6Njg8nBs+whlO+zxpU4i0wy4KWDdt9GfMJedLgfLClLR9K0I3dSheT339H skamphoff@saskia.local 
ssh-rsa AAAAB3NzaC1yc2EAAAABJQAAAQEAyh9JmipuyW5kk4LsvtxD5aiwYXQYdWAXMgKGJcOHm5XGP4R62nwjvCPS0JuXMQRyvayy9EjKfnZ4BzF0zacDMNwOgZDubMxy0bHt0XKyO1lpKVQJBWBUeAZtzfMceo/NYPX/WC6FlBFI9p5NIsTCU4BkTaLJt3si7z865hkxxzBvv4KpebyWbdCqRcGbohwbgwZQvmWZSiwfBnlfR0vQWleZVDv8HIHrfKxnuYYzeO0LSNcDn4flknVNZhB3ClDjXAZBpqpjST3nvoUOdtvBzEYSutZ9TiEBzXhuHmHKLrwlpX5s448xXsECXDBuK7Tn5W/z6y0cX0z6BtBz1gyrWQ== rsa-key-20181010-michael-notebook 
ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQDDAj5HEdPDycwWXFkOb0A+eS2unzh7ruONNsqqLmDBrxwD25wD7K1bx8gF7HM5bVNzleoWoR5w4vLMwS5bnLAUXwkQ8VevEWruaaFThQpUj9QOIedjVo77j9aEcXaw0X6V/gjX/zSsX6fV+H4M992Y/4GSgrAlP0r5REmc8t6mAidHqe25D1fTgBy2jCYksJmetT7Gy+HCBUp00aJo1BHbqMLvclklfZB6nrEQCxlWjDK9CPfGTxVfF/IA6y1o61QanHQ1i1G2Kf7nZNVpRsv+hnIh8KuKdwz8WRgJp1Nwv8UBINE9VfJOEI7FWPq6/sJxeSXNR3IbjoNJxXcsxDSB root@HCC-MG-01 
ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQDIEJTbMPJbwO4mrllHoshZSEz3TSqkVlAI0d/N1+Jxrwt3E3z98w9kMMc7XkINtN9THBTkmXi2MJorABzLtk6wiDivTfBHTp27BaGkeBYfa9XM6c6I4LSYouiTG3TcGRhd0imtQnTvosGXYJOerrlVcZlBpOz9XEcmjD4Fgfy3n/jRJHkWGgt07f8P+SBEIkeDIsf8DJQ9Bm5Ap04A0JKlJ7NenmBieQNJ0ZKCrfN5L2AdQ1fONBpiet0WnSGqUZnbL7MonwMhLdFusSEbj3eSGOmPxWM9cl9DX2KRqxDwWZfcumBomX01nxyelx9mIPgsFJDRCl43NN+TTUumG/E7 root@dcdus-hcc03
ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABgQCsF9dX9iBJWCgp5NSQFuX0k9+hx69xeRV0h5qVjc4fHJ4Ur61t9ltz2kQIjX9R0HYu1KMoweVBjwNr1cAFIk18XotP5KdR/Xdbpyo1ghcQB5u1HLtdkMCeO0HXNPc02o6ZQ0SGnXXKGI/4umL4iEDaq82yyhRa548BjA+Iio+FJ6kzf/88NkUGoc5UNFTUG7lpQcqyGnlv83jKfH85Psr0j3lyVVHqLT6U++yKurD0LUD7tuhvP29qhSjyuioFtsBotj7haaeQyg4HnTIazGNP/Jz0WCOSyTuNrvj1GlIQK4XzvHglbZi15zMbm3loXA7ryMqIAO2YdwCDKYS9KpccTEf2EWtal1dPBz/m3n8VyeUv7J8HXReVM7+OfM3gNiutf5A4XB7eTLXFwP1AL1Krh2cG/SUVwARcmLGE2PLA+N3xfZ3iQTfONrFaKjB9Y+g7PSh9+Whtf8xX/ytdRo98uUjyejJQgZITIUHQyB2uFpkDe/0Ku8Sjv0RX5ubw+GE= root@hcc-mg-03
ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQDIEJTbMPJbwO4mrllHoshZSEz3TSqkVlAI0d/N1+Jxrwt3E3z98w9kMMc7XkINtN9THBTkmXi2MJorABzLtk6wiDivTfBHTp27BaGkeBYfa9XM6c6I4LSYouiTG3TcGRhd0imtQnTvosGXYJOerrlVcZlBpOz9XEcmjD4Fgfy3n/jRJHkWGgt07f8P+SBEIkeDIsf8DJQ9Bm5Ap04A0JKlJ7NenmBieQNJ0ZKCrfN5L2AdQ1fONBpiet0WnSGqUZnbL7MonwMhLdFusSEbj3eSGOmPxWM9cl9DX2KRqxDwWZfcumBomX01nxyelx9mIPgsFJDRCl43NN+TTUumG/E7 root@dcdus-hcc03
ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQC4EhIIhIf0hyGjDOQMTVWYdcUHqrklNKVX5ldGEg7OJ0SuwWJbZJeAcqgkGVAh7GRchgHC3RrIurITcOQO6Tdpj8Fy7K48oN8AlMd3yAACchuDeXY8ADSSd4mfcsRjdoepif8JMoVATE2fRvyrqHD+KYwppv+zcvb+Dp6kCxDuuwx/3gsUiBlOUQRcQAeK51OQvdxAicxewS95qYFoqVfMNm04zf436XNEyWHo2Fpn/DGzn3m/onBSu5zjcG4xc2LA3yBFmrr0Ba2+1Z0MmZRiCo7JEbK4AjGW68+L8s0h4wyrIh/o0g8NWacFq4pJBtzUh3w+XSJCEP104lOvDMM3 isystems\stuecking@Samuel-L13
__ALLE-KEYS__

#CONFIG
cat /proc/sys/vm/swappiness && sysctl vm.swappiness=10 && swapoff -a && sysctl vm.swappiness=10 && swapon -a
cat << EOF > /etc/sysctl.conf
net.ipv4.ip_forward = 1  # tailscale
#vm.swappiness      = 60 # default
 vm.swappiness      = 10 # enough
#vm.swappiness      = 0  # low
EOF
sysctl -p /etc/sysctl.conf

#UPDATES
wget https://pkgs.tailscale.com/stable/debian/bullseye.gpg && apt-key add bullseye.gpg && rm bullseye.gpg
rm /etc/apt/sources.list.d/*.list
cat << EOF > /etc/apt/sources.list.d/pve-no-subscription.list
deb http://download.proxmox.com/debian/pve bullseye pve-no-subscription
deb http://download.proxmox.com/debian/pbs bullseye pbstest
deb https://pkgs.tailscale.com/stable/debian bullseye main
EOF
apt update -y && apt upgrade -y && apt auto-clean -y

apt update && apt install -y systemd-timesyncd
cat << EOF > /etc/systemd/timesyncd.conf
[Time]
NTP=134.130.4.17
FallbackNTP=134.130.5.17
RootDistanceMaxSec=5
PollIntervalMinSec=32
PollIntervalMaxSec=2048
EOF
systemctl restart systemd-timesyncd

#NAG
echo "DPkg::Post-Invoke { \"dpkg -V proxmox-widget-toolkit | grep -q '/proxmoxlib\.js$'; if [ \$? -eq 1 ]; then { echo 'Removing subscription nag from UI...'; sed -i '/data.status/{s/\!//;s/Active/NoMoreNagging/}' /usr/share/javascript/proxmox-widget-toolkit/proxmoxlib.js; }; fi\"; };" > /etc/apt/apt.conf.d/no-nag-script && apt --reinstall install proxmox-widget-toolkit
sed -i.bak "s/data.status !== 'Active'/false/g" /usr/share/javascript/proxmox-widget-toolkit/proxmoxlib.js && systemctl restart pveproxy.service

#PACKAGES
apt update && apt install -y nfs-kernel-server mdadm parted screen nginx ifupdown2 iftop proxmox-backup-server fio lshw cloud-guest-utils libsasl2-modules postfix-pcre gnupg2 cloud-guest-utils ethtool tailscale
rm /etc/apt/sources.list.d/*enterprise*

#INTERFACES
ip link show
nic=eno1
ethtool $nic
ethtool -i $nic
ethtool -S $nic
ethtool -p $nic 6

#TAILSCALE
hostname="1122334455566.hostname.customer.partner";routes="192.168.22.0/24";authkey="tskey-b12beb40c36a8a4530ef0422";
systemctl enable --now tailscaled;sleep 3;tailscale up --authkey=$authkey --hostname=$hostname --advertise-routes="$routes" --accept-routes=false --accept-dns=false
#disable key expiry
#do not enable subnet routes

cp /etc/hosts /etc/hosts.bak && cat << EOF > /etc/hosts
127.0.0.1      localhost.localdomain localhost
192.168.22.112 pve.pls.intern pve pbs.pls.intern pbs
::1            ip6-localhost ip6-loopback
fe00::0        ip6-localnet
ff00::0        ip6-mcastprefix
ff02::1        ip6-allnodes
ff02::2        ip6-allrouters
ff02::3        ip6-allhosts
EOF

#NGINX
mv /etc/nginx/sites-enabled/default /etc/nginx/default.bak && cat << 'EOF' > /etc/nginx/conf.d/proxmox.conf
upstream proxmox {
 server pve;
}
server {
 listen 80 default_server;
 rewrite ^(.*) https://$host$1 permanent;
}
server {
 listen 443 ssl http2;
 server_name _;
 ssl on;
 ssl_certificate /etc/proxmox-backup/proxy.pem;
 ssl_certificate_key /etc/proxmox-backup/proxy.key;
 proxy_redirect off;
 location / {
  proxy_http_version 1.1;
  proxy_set_header Upgrade $http_upgrade;
  proxy_set_header Connection "upgrade";
  proxy_pass https://localhost:8006;
  proxy_buffering off;
  client_max_body_size 0;
  proxy_connect_timeout 3600s;
  proxy_read_timeout 3600s;
  proxy_send_timeout 3600s;
  send_timeout 3600s;
 }
}
EOF
#https://forum.proxmox.com/threads/nginx-kommt-beim-systemstart-nicht-hoch.36631/
cat << EOF > /etc/systemd/system/nginx.service
[Unit]
Description=A high performance web server and a reverse proxy server
After=remote-fs.target
After=pve-cluster.service
Wants=pve-cluster.service                                                                                                     
[Service]
Type=forking
PIDFile=/run/nginx.pid
ExecStartPre=/usr/sbin/nginx -t -q -g 'daemon on; master_process on;'
ExecStartPost=/usr/bin/sleep 10
ExecStart=/usr/sbin/nginx -g 'daemon on; master_process on;'
ExecReload=/usr/sbin/nginx -g 'daemon on; master_process on;' -s reload
ExecStop=-/sbin/start-stop-daemon --quiet --stop --retry QUIT/5 --pidfile /run/nginx.pid
TimeoutStopSec=5
KillMode=mixed
[Install]
WantedBy=multi-user.target
EOF
nginx -t && systemctl restart nginx && systemctl enable nginx

#SNMP
wget https://raw.githubusercontent.com/librenms/librenms-agent/master/agent-local/proxmox -O /usr/local/bin/proxmox && chmod +x /usr/local/bin/proxmox && apt-get update && apt-get -y install snmpd libpve-apiclient-perl && mv /etc/snmp/snmpd.conf /etc/snmp/snmpd.conf.backup
cat << EOF > /etc/snmp/snmpd.conf
rocommunity public 192.168.22.0/24
syslocation  "rack"
syscontact  "support_eu@isystems-integration.com"
agentAddress  udp:161
agentuser root
dontLogTCPWrappersConnects yes
realStorageUnits 0
extend proxmox /usr/local/bin/proxmox
# snmp ALL=(ALL) NOPASSWD: /usr/local/bin/proxmox
EOF
service snmpd restart && systemctl enable snmpd && update-rc.d snmpd enable

#SCREEN
cat << EOF > ~/.screenrc
startup_message off
vbell off
defscrollback 10000
hardstatus alwayslastline
hardstatus string '%{= kG}[ %{G}%H %{g}][%= %{= kw}%?%-Lw%?%{r}(%{W}%n*%f%t%?(%u)%?%{r})%{w}%?%+Lw%?%?%= %{g}][%{B} %m-%d %{W}%c %{g}]'
EOF

#MISC
#lvremove /dev/pve/data entfernt local-lvm: https://docs.linuxmuster.net/de/latest/getting-started/installoptions/install-on-proxmox/
#https://www.osarea.com/zfs-storage-server-setup-zfs-in-proxmox-from-command-line-with-l2arc-and-log-on-ssd
#https://pve.proxmox.com/wiki/Nested_Virtualization
echo "options kvm-intel nested=Y" > /etc/modprobe.d/kvm-intel.conf && modprobe -r kvm_intel

#ROOT
lvdisplay
# If for example we want to resize pve-data to be 10GB and gave pve-root all the other size we can do it by this commands
# remove pve-data logical volume.
lvremove /dev/pve/data -y
# create it again with new size.
lvcreate -L 24G -n data pve -T
# give pve-root all the other size.
lvresize -l +100%FREE /dev/pve/root
# resize pve-root file system
#resize2fs /dev/mapper/pve-root
xfs_growfs /

#RAID
systemctl enable fstrim.timer
systemctl start fstrim.timer
lsblk
parted -s /dev/sda mklabel gpt
#fdisk /dev/sda
mkfs.xfs /dev/sda -f
mkdir /mnt/ssd
mkdir /mnt/ssd/0
blkid
echo 'UUID=731515fc-529a-417c-8829-ca30304e42ec /mnt/ssd/0 xfs defaults 0 1'>>/etc/fstab
#NFS
echo '/mnt/ssd/0 *(rw,no_root_squash,async)'>/etc/exports
service nfs-kernel-server restart

#UPDATES
apt update && apt upgrade -y && apt auto-clean -y 

#BACKUP CONFIG (https://github.com/DerDanilo/proxmox-stuff)
export BACK_DIR="/mnt/ssd/0/backup";mkdir $BACK_DIR;chmod -R 777 $BACK_DIR;
cd /root/ && wget -q -O /root/prox_config_backup.sh  https://raw.githubusercontent.com/DerDanilo/proxmox-stuff/master/prox_config_backup.sh
chmod +x /root/prox_config_backup.sh
./prox_config_backup.sh

#PBS
mkdir /mnt/ssd/0/pbs

#NETWORKING
cat << EOF > /etc/network/interfaces
auto lo
iface lo inet loopback
iface eno1 inet manual
iface eno2 inet manual
iface eno3 inet manual
iface eno4 inet manual
iface enp183s0f0 inet manual
iface enp183s0f1 inet manual
iface enp183s0f2 inet manual
iface enp183s0f3 inet manual
auto bond0
iface bond0 inet manual
 bond-slaves eno3 enp183s0f0
 bond-miimon 100
 bond-mode active-backup
 bond-primary enp183s0f0
 #clusterAccess
auto bond1
iface bond1 inet manual
 bond-slaves eno1 enp183s0f2
 bond-miimon 100
 bond-mode active-backup
 bond-primary enp183s0f2
 #cluster1
auto bond2
iface bond2 inet manual
 bond-slaves eno2 enp183s0f3
 bond-miimon 100
 bond-mode active-backup
 bond-primary enp183s0f3
 #cluster2
auto vmbr0
iface vmbr0 inet static
 address  192.168.10.52
 netmask  24
 gateway  192.168.10.1
 bridge-ports bond0
 bridge-stp off
 bridge-fd 0
auto vmbr1
iface vmbr1 inet static
 address  192.168.21.52
 netmask  24
 bridge-ports bond1
 bridge-stp off
 bridge-fd 0
 bridge-vlan-aware yes
 bridge-vids 2-4094
auto vmbr2
iface vmbr2 inet static
 address  192.168.22.52
 netmask  24
 bridge-ports bond2
 bridge-stp off
 bridge-fd 0
 bridge-vlan-aware yes
 bridge-vids 2-4094
EOF
reboot

#CONFIGS
#/etc/pve
#corosync.conf
logging {
  debug: off
  to_syslog: yes
}
nodelist {
  node {
    name: pve1
    nodeid: 1
    quorum_votes: 1
    ring0_addr: 192.168.22.51
    ring1_addr: 192.168.21.51
  }
  node {
    name: pve2
    nodeid: 2
    quorum_votes: 1
    ring0_addr: 192.168.22.52
    ring1_addr: 192.168.21.52
  }
  node {
    name: pve3
    nodeid: 3
    quorum_votes: 1
    ring0_addr: 192.168.22.53
    ring1_addr: 192.168.21.53
  }
  node {
    name: pve4
    nodeid: 4
    quorum_votes: 1
    ring0_addr: 192.168.22.54
    ring1_addr: 192.168.21.54
  }
}
quorum {
  provider: corosync_votequorum
}
totem {
  cluster_name: hotel
  config_version: 4
  interface {
    linknumber: 0
  }
  interface {
    linknumber: 1
  }
  ip_version: ipv4-6
  link_mode: passive
  secauth: on
  version: 2
}
#datacenter.cfg
keyboard: de
migration: network=192.168.22.51/24,type=secure
#storage.cfg
zfspool: zfs1
	pool zfs1/nfs
	content images,rootdir
	nodes pve2,pve1
	sparse 0
nfs: pve1zfs1
	export /zfs1/nfs
	path /mnt/pve/pve1zfs1
	server 192.168.22.51
	content vztmpl,images,iso,rootdir,snippets,backup
	maxfiles 7
nfs: pve1ssd0
	export /mnt/ssd/0
	path /mnt/pve/pve1ssd0
	server 192.168.22.51
	content iso,rootdir,snippets,backup,vztmpl,images
	maxfiles 7
nfs: pve1nvme1
	export /mnt/nvme/1
	path /mnt/pve/pve1nvme1
	server 192.168.22.51
	content vztmpl,images,rootdir,snippets,iso,backup
	maxfiles 7
nfs: pve1ssd1
	export /mnt/ssd/1
	path /mnt/pve/pve1ssd1
	server 192.168.22.51
	content vztmpl,images,snippets,rootdir,iso,backup
	maxfiles 7
nfs: ds415
	export /volume1/etc/pve
	path /mnt/pve/ds415
	server 192.168.10.11
	content vztmpl,images,iso,rootdir,snippets,backup
	maxfiles 7
nfs: pve2nvme1
	export /mnt/nvme/1
	path /mnt/pve/pve2nvme1
	server 192.168.22.52
	content rootdir,snippets,iso,backup,vztmpl,images
	maxfiles 7
nfs: pve2ssd0
	export /mnt/ssd/0
	path /mnt/pve/pve2ssd0
	server 192.168.22.52
	content images,vztmpl,backup,snippets,rootdir,iso
	maxfiles 7
nfs: pve2ssd1
	export /mnt/ssd/1
	path /mnt/pve/pve2ssd1
	server 192.168.22.52
	content iso,snippets,rootdir,backup,vztmpl,images
	maxfiles 7
nfs: pve2zfs1
	export /zfs1/nfs
	path /mnt/pve/pve2zfs1
	server 192.168.22.52
	content snippets,rootdir,iso,backup,vztmpl,images
	maxfiles 7
nfs: pve3ssd0
	export /mnt/ssd/0
	path /mnt/pve/pve3ssd0
	server 192.168.22.53
	content rootdir,snippets,iso,backup,vztmpl,images
	maxfiles 7
nfs: pve3ssd1
	export /mnt/ssd/1
	path /mnt/pve/pve3ssd1
	server 192.168.22.53
	content backup,iso,rootdir,snippets,images,vztmpl
	maxfiles 7
nfs: pve4ssd0
	export /mnt/ssd/0
	path /mnt/pve/pve4ssd0
	server 192.168.22.54
	content vztmpl,images,snippets,rootdir,iso,backup
	maxfiles 7
nfs: pve4ssd1
	export /mnt/ssd/1
	path /mnt/pve/pve4ssd1
	server 192.168.22.54
	content snippets,rootdir,iso,backup,vztmpl,images
	maxfiles 7
nfs: pve5hdd0
	disable
	export /mnt/hdd/0
	path /mnt/pve/pve5hdd0
	server 192.168.10.55
	content backup
	maxfiles 1
	nodes pve2
dir: local
	disable
	path /var/lib/vz
	content rootdir,snippets,iso,images,vztmpl
	maxfiles 0
	shared 0
dir: localssd
	path /mnt/ssd/0
	content images,vztmpl,backup,rootdir,snippets,iso
	maxfiles 7
	shared 0
nfs: pve4hdd0
	export /mnt/hdd/0
	path /mnt/pve/pve4hdd0
	server 192.168.22.54
	content images,vztmpl,backup,iso,snippets,rootdir
	maxfiles 14
#vzdump.cron,# cluster wide vzdump cron schedule,# Automatically generated file - do not edit
PATH="/usr/sbin:/usr/bin:/sbin:/bin"
15 0 * * *           root vzdump 1011002 1012002 1010120 1001021 1001020 1001002 1010250 --compress lzo --mailnotification failure --mode snapshot --quiet 1 --storage pve4hdd0
0 5 * * 7           root vzdump 1001003 1001004 1001005 --mode snapshot --quiet 1 --mailnotification failure --storage pve4hdd0 --compress lzo

#nut ups monitor
apt install ifupdown -y
apt install ifupdown2 -y
apt install -y nut-client
touch /etc/nut/hosts
touch /etc/nut/notify
touch /etc/nut/nut.conf
touch /etc/nut/upsmon.conf
touch /etc/nut/upssched.conf
cp /etc/nut/hosts /etc/nut/hosts.bak
cp /etc/nut/notify /etc/nut/notify.bak
cp /etc/nut/nut.conf /etc/nut/nut.conf.bak
cp /etc/nut/upsmon.conf /etc/nut/upsmon.conf.bak
cp /etc/nut/upssched.conf /etc/nut/upssched.conf.bak
chown -R root:root /etc/nut
chmod -R 640 /etc/nut
chown root:nut /etc/nut/notify
chmod 740 /etc/nut/notify
nano /etc/nut/upsmon.conf
nano /etc/nut/upsmon.conf
echo ''>/etc/nut/upsmon.conf && nano /etc/nut/upsmon.conf
echo ''>/etc/nut/nut.conf && nano /etc/nut/nut.conf
echo ''>/etc/nut/notify && nano /etc/nut/notify
echo ''>/etc/nut/hosts && nano /etc/nut/hosts
echo ''>/etc/nut/upssched.conf && nano /etc/nut/upssched.conf
systemctl enable nut-client && systemctl start nut-client && systemctl status nut-client
#root@pve2:~# cat /etc/nut/hosts
#MONITOR ups@192.168.10.8  "DS4151:Back-UPS-RS-1500G"
#MONITOR ups@192.168.10.9  "DS4152:Back-UPS-RS-1500G"
#MONITOR ups@192.168.10.11 "DS415: Back-UPS-RS-1500G"
#
#root@pve2:~# cat /etc/nut/notify
##! /bin/sh
#echo "$*" | mailx -s "PVE2:NUTCLIENT" michael@hotel-esser.com
#root@pve2:~# cat /etc/nut/nut.conf
#MODE=netclient
#root@pve2:~# cat /etc/nut/upsmon.conf
#DEADTIME 30
#FINALDELAY 5
#HOSTSYNC 15
#MINSUPPLIES 1
#NOCOMMWARNTIME 300
#NOTIFYCMD /etc/nut/notify
#NOTIFYFLAG COMMBAD SYSLOG+WALL+EXEC
#NOTIFYFLAG COMMOK SYSLOG+WALL+EXEC
#NOTIFYFLAG FSD SYSLOG+EXEC
#NOTIFYFLAG LOWBATT SYSLOG+WALL+EXEC
#NOTIFYFLAG NOCOMM SYSLOG+EXEC
#NOTIFYFLAG ONBATT SYSLOG+WALL+EXEC
#NOTIFYFLAG ONLINE SYSLOG+WALL+EXEC
#NOTIFYFLAG REPLBATT SYSLOG+WALL+EXEC
#NOTIFYFLAG SHUTDOWN SYSLOG+EXEC
#POLLFREQ 5
#POLLFREQALERT 1
#POWERDOWNFLAG /etc/killpower
#RBWARNTIME 43200
#RUN_AS_USER nut
#SHUTDOWNCMD "/sbin/shutdown -h +0"
#MONITOR ups@192.168.10.11 1 monuser secret slave #DS415: Back-UPS-RS-1500G
##MONITOR ups@192.168.10.8  1 monuser secret slave #DS4151:Back-UPS-RS-1500G
##MONITOR ups@192.168.10.9  1 monuser secret slave #DS4152:Back-UPS-RS-1500G
#
#root@pve2:~# cat /etc/nut/upssched.conf
#CMDSCRIPT /bin/upssched-cmd
#root@pve2:~# cat /bin/upssched-cmd
##! /bin/sh
##
## This script should be called by upssched via the CMDSCRIPT directive.
##
## Here is a quick example to show how to handle a bunch of possible
## timer names with the help of the case structure.
##
## This script may be replaced with another program without harm.
##
## The first argument passed to your CMDSCRIPT is the name of the timer
## from your AT lines.
#
#case $1 in
#        upsgone)
#                logger -t upssched-cmd "The UPS has been gone for awhile"
#                ;;
#        *)
#                logger -t upssched-cmd "Unrecognized command: $1"
#                ;;
#esac
#