# NOTES
- [x] M2,Raid1=32GB,hdsize=24GB,swapsize=8GB
- [-] SSDs=Raid5,512K,DriveCache=Enabled,Init=Full
- [ ] Storage per NFS einbinden mit Hostname
- [ ] ISO NFS einbinden
- [ ] Backups einrichten mit PBS
- [ ] /etc/hosts editieren
- [ ] Updates Installieren
- [ ] Backup Server Grundconfig
- [ ] 
- [ ] 
- [ ] 
- [ ] 
- [ ] 
- [ ] 
- [ ] 
- [ ] 
- [ ] 
- [ ] 
- [ ] 
- [ ] 

# LINKS
#https://docs.linuxmuster.net/de/latest/installation/proxmox/index.html#bereitstellen-des-proxmox-hosts
#https://github.com/Corsinvest/awesome-proxmox-ve
#https://github.com/extremeshok/xshok-proxmox
#https://gist.github.com/mrpeardotnet/e6bc57ed899c948ba53b3193a202eb2c
#https://www.hungred.com/how-to/server/list-of-useful-proxmox-command/
#https://gist.github.com/mrpeardotnet/6bdc4b504f43ce57fa7eaee96d376edf#file-pve-host-backup-md
#https://github.com/DerDanilo/proxmox-stuff
#https://cheatography.com/the-iceman-blog/cheat-sheets/zfs-command-line-reference/

# ISO
https#https://files.jezz.systems/template/iso/proxmox-ve_7.2-1.iso

# CD
Disk:XFS with 8GB swap
Email:sysmessages@isystems.email
Netw:eno1,pve1k.kluthe.local
Netw:eno1,pve2k.kluthe.local
Netw:eno1,pve3k.kluthe.local

# SSH
passwd
#/home/ansible/files/00-all_keys.txt
cat > /root/.ssh/authorized_keys << __ALLE-KEYS__
ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQDiak2aW6hwqeTs4/+oA/y09AXCjjc4EEKTmOaU0AIXY1OMD/syVz4rHV8VLohcE6tmzjzXZDmDuFSY7XnoBrBJR/ZEfCbQFCpaOQ1VZ7Z/BtRagPkjsZxUpeQ6+VQz8VmsCfxI4nhg19OOk2gBv0/hQD1HGmE2Rcu0JL2l4maZJUnCcCYhsb7j+m9B/jissncI59XjBGUSfIgixId0uUbcpW/Ze67HdhcTaImlra5zC+RPdJJSLfrlyRP+G1sDHNaS/fJXk7oLIOHpQo0zifDUkcWcKlWR201WG8pIjmUsoaBuGO69y/KIqR3fJoWArDD3uKzAqkmC2PoZYa5OWhBd root@HCC-02 
ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQCxo9UZTTksrYaTU8UVHIa6wb5+kpywel5j2kSpkYG9ibb+6zOE+VzchRAm03Gtw7Y5CT9VAQdHpCvaZJn2flxb73vU0gO/acKSRIhINz/QO33bYQnN5gX7D53Vy7TlY259/kHfOvIUGq3BF+lYF4wHrOhEbVMwjCJrH2NQfmmsfPtS6prGJba+dh0FV4K4jkX6fD9vxLST7ulbrssUxF9PcGRVmI0FOYVI2YWBZMaJp1QVLo/vwEQbDH4PCMiMOtBX5C6ot7dUgu2H+nmEeu0LWaQh+JYP3jR7yOfFLD6mkVoAkZDLkljEMJxhC21TZpbtgTf9CeTWEVj0qnIxsxml root@HCC-RZL3-01 
ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQDClquILDs6oqokrkNS4WjKt3mh0rBuXM6VOpjKT5WV3cqiogZ8AP7tHQAIYjEPdkqDi9i7nSLEHsYV8t+Lc7W5A5DBeiSG27Fhf5H/RVbXY1TMmoMpnqAHbFVRiOY1rv9gp7j9Vu7uOYSKnVQnH7dra1N4HdBaGo/uuM3mPZCaOgqLl3RBATb0dU8mTW/eznrb69rYK3gw9U1/u0v6SopPLLBMkYQSx/jadr/L7gAIRa9yu+5sngt4jewAsqC4puU7xunjJndKGnWseYcyOzmYub2p5ce7Gia/j1RbPOF3++vwpiZAfi4clny+Ra8fwlgb9TLU+CS3bVBlBUIlfZjd klaus@Lenovo-P310 
ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQC7c2DfsgOCNSrX8GwwudGGMbmSyigGnv6bM4yCXhbE2wnPhBdF02N2JZxa1URgbaT69Q/U+Gnv7GwC0ZnJUixPcz7eNj3/U9uHstwk7FSxBfAot+M8svSE7kSLoFxf3l99QdbHneNa67K4g2pukbwtjmypChGp7X0f/gixa8VmSvGbIrwAYhZyAvXCPYPY+HFnvVz0z2KR4taq2t5gbBdpW/F/ppV4KpNDZDgkFaFSQ1EKFPWGrsetbwE6vWaPwm+JcH08CgL8fbv9JvMJmPCtkOtluIwsPV6eSLpv81v9digDYmbgYufBmrbmaplHhUaps3iA59tZReH+WVOgQHMf root@Lenovo-P310 
ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQCz2BbQyhA75M+goDLoQeQqhqQkyoYduweOxxndza8dPhCoWIF2tZFie0SPae8TFOspQ0OMHrwxCNyWsUomSxYmRi7u24+gAcV19/ZN3USlGObJ1tscx1QIucUJ2iikNuAo8pu5PpHvRBvqQ13ZZvRXidLTRK60UkQMOPhCviNIRLn9kh5iOI6NxAbaiojPaMdyr5SS0ExUX0PBXpdFcYeLXfBNA4RMyNBC3vWGalEMcbTvQ+KtMY55oSg+69+jhGPccuY2MmwNdP1aFpBxhSuyIu/wa/lD//zHSraY0QgxuTFzw1oTWlvXApeFNT3WJydrpc1TnEvJ6EZiMooDhjet klaus@X349m 
ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQCsDPj4VCKj8Aab8QGDdsL2YEL+eBiKiTzBHFgRfxxd485GtVvfYEM7ElnEVEkjFU1rP6VZcSP/k/13vlkfaMHCs1ep2dmYon7UvXiKd6LTEz1thgDL2OdRVDluL5lTPxCF5LM/wQEbrI31cRs/H2g1GE3TUcC2uYtPnoN6ZDAwdqze2sIFqF/HJPOnStGaQk89IFonvetYSBwxLdqzQ9UE4yHA5vC2nplJ5+Lzifn0wdaYikyMMFgU6iHxeJLwYO9IFVzLtuy/hV11NNCczJhZ78B883aPe6Uz7vVH7PrzFYpRhRMfD/v585wHAaD2ifa4QTGZ2v8EP+Bfdx1RkRxp root@X349m 
ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQCfZuhHrytwVj8SbzDWG+aUhxqyyP1szL1jHUqxmH8SIawLrl3aEpwXFFRxn+NeMlKktuHFBzmp07IQJspYQCE15nqJeUkB8LlMKeV7AyfKrPCDUICo1F6CweEaGduR0LKlyIBlI6uzwvdX7xJ8IvvFXXy1SSXJweecxHxkQvtSFS5uC4ba1VJqPoPTLms1+YyTLB1IFrM18qcu4vJsPrILsq2/x1773THQ2uFVfROwwi0S7HbjwKkeZDuqGtwDcn8LZ+tCsO83tSVyRheImIdDNSatQLJu7fFXp8w6w5H/RvLL5K8ihcwGs35xJ90jh6eOPLhbPxiKgrXVXVAgLK2F root@HMC-01 
ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQDBejZNhe/b5G5osjHujDF/I+l27RBKEK4pso73M4JtyBFD0XpsloifA4b0/AF2p9fjV0pf79rfWmRaAeZl+mKALuaGnUc17CjI0omw977pQLhOVXYQDAC4yhUbk63FaIwyQ49WXKTnzbPC2h+LSWK9aOKBejSdibnM2hYMvnSZg69ckFySTNsto6vC4dYGyy/zttERTyLczE2dsSZy2kdytwurB724EiE6vuBHDYgwp796Mjp4FTDXOg9NPEvqBPhlLDPQ3YaV2pZhzn579O2vxM4XUtXqcx5NckgFgdBUnQupFQVMDlyvlf3GAUl7kt1S8dDNeWrRSpxWFaQWeEXx root@dctpa-hcc-01 
ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQDiCpHdqyjOlGLAjEpYqhH+Hdrd71e6gRxJN3h1DWgubK0ygP2oltEaO5isFnsw31K4oQJly86XaxiWpBDGYuDawiUTWS4HpLMBJROqiUo3sGGis6/1hxJdsA5aBo99mnVedqLWSOzaGf3gEBMMpaUlI6IlHrQYbAB8IEd8AklqGb8eOv/0eGqPdBzTbcWQF93O/2RDux09aMfDcNaCT3i0pVGKE9eG4n/KTdp7FkwRwEPIhCwc3+Y8KX7B4PzIGlGIQ+wLUG94ebTtItgV2C65g/iXSM6Njg8nBs+whlO+zxpU4i0wy4KWDdt9GfMJedLgfLClLR9K0I3dSheT339H skamphoff@saskia.local 
ssh-rsa AAAAB3NzaC1yc2EAAAABJQAAAQEAyh9JmipuyW5kk4LsvtxD5aiwYXQYdWAXMgKGJcOHm5XGP4R62nwjvCPS0JuXMQRyvayy9EjKfnZ4BzF0zacDMNwOgZDubMxy0bHt0XKyO1lpKVQJBWBUeAZtzfMceo/NYPX/WC6FlBFI9p5NIsTCU4BkTaLJt3si7z865hkxxzBvv4KpebyWbdCqRcGbohwbgwZQvmWZSiwfBnlfR0vQWleZVDv8HIHrfKxnuYYzeO0LSNcDn4flknVNZhB3ClDjXAZBpqpjST3nvoUOdtvBzEYSutZ9TiEBzXhuHmHKLrwlpX5s448xXsECXDBuK7Tn5W/z6y0cX0z6BtBz1gyrWQ== rsa-key-20181010-michael-notebook 
ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQDDAj5HEdPDycwWXFkOb0A+eS2unzh7ruONNsqqLmDBrxwD25wD7K1bx8gF7HM5bVNzleoWoR5w4vLMwS5bnLAUXwkQ8VevEWruaaFThQpUj9QOIedjVo77j9aEcXaw0X6V/gjX/zSsX6fV+H4M992Y/4GSgrAlP0r5REmc8t6mAidHqe25D1fTgBy2jCYksJmetT7Gy+HCBUp00aJo1BHbqMLvclklfZB6nrEQCxlWjDK9CPfGTxVfF/IA6y1o61QanHQ1i1G2Kf7nZNVpRsv+hnIh8KuKdwz8WRgJp1Nwv8UBINE9VfJOEI7FWPq6/sJxeSXNR3IbjoNJxXcsxDSB root@HCC-MG-01 
ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQDIEJTbMPJbwO4mrllHoshZSEz3TSqkVlAI0d/N1+Jxrwt3E3z98w9kMMc7XkINtN9THBTkmXi2MJorABzLtk6wiDivTfBHTp27BaGkeBYfa9XM6c6I4LSYouiTG3TcGRhd0imtQnTvosGXYJOerrlVcZlBpOz9XEcmjD4Fgfy3n/jRJHkWGgt07f8P+SBEIkeDIsf8DJQ9Bm5Ap04A0JKlJ7NenmBieQNJ0ZKCrfN5L2AdQ1fONBpiet0WnSGqUZnbL7MonwMhLdFusSEbj3eSGOmPxWM9cl9DX2KRqxDwWZfcumBomX01nxyelx9mIPgsFJDRCl43NN+TTUumG/E7 root@dcdus-hcc03
ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABgQCsF9dX9iBJWCgp5NSQFuX0k9+hx69xeRV0h5qVjc4fHJ4Ur61t9ltz2kQIjX9R0HYu1KMoweVBjwNr1cAFIk18XotP5KdR/Xdbpyo1ghcQB5u1HLtdkMCeO0HXNPc02o6ZQ0SGnXXKGI/4umL4iEDaq82yyhRa548BjA+Iio+FJ6kzf/88NkUGoc5UNFTUG7lpQcqyGnlv83jKfH85Psr0j3lyVVHqLT6U++yKurD0LUD7tuhvP29qhSjyuioFtsBotj7haaeQyg4HnTIazGNP/Jz0WCOSyTuNrvj1GlIQK4XzvHglbZi15zMbm3loXA7ryMqIAO2YdwCDKYS9KpccTEf2EWtal1dPBz/m3n8VyeUv7J8HXReVM7+OfM3gNiutf5A4XB7eTLXFwP1AL1Krh2cG/SUVwARcmLGE2PLA+N3xfZ3iQTfONrFaKjB9Y+g7PSh9+Whtf8xX/ytdRo98uUjyejJQgZITIUHQyB2uFpkDe/0Ku8Sjv0RX5ubw+GE= root@hcc-mg-03
ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQDIEJTbMPJbwO4mrllHoshZSEz3TSqkVlAI0d/N1+Jxrwt3E3z98w9kMMc7XkINtN9THBTkmXi2MJorABzLtk6wiDivTfBHTp27BaGkeBYfa9XM6c6I4LSYouiTG3TcGRhd0imtQnTvosGXYJOerrlVcZlBpOz9XEcmjD4Fgfy3n/jRJHkWGgt07f8P+SBEIkeDIsf8DJQ9Bm5Ap04A0JKlJ7NenmBieQNJ0ZKCrfN5L2AdQ1fONBpiet0WnSGqUZnbL7MonwMhLdFusSEbj3eSGOmPxWM9cl9DX2KRqxDwWZfcumBomX01nxyelx9mIPgsFJDRCl43NN+TTUumG/E7 root@dcdus-hcc03
ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQC4EhIIhIf0hyGjDOQMTVWYdcUHqrklNKVX5ldGEg7OJ0SuwWJbZJeAcqgkGVAh7GRchgHC3RrIurITcOQO6Tdpj8Fy7K48oN8AlMd3yAACchuDeXY8ADSSd4mfcsRjdoepif8JMoVATE2fRvyrqHD+KYwppv+zcvb+Dp6kCxDuuwx/3gsUiBlOUQRcQAeK51OQvdxAicxewS95qYFoqVfMNm04zf436XNEyWHo2Fpn/DGzn3m/onBSu5zjcG4xc2LA3yBFmrr0Ba2+1Z0MmZRiCo7JEbK4AjGW68+L8s0h4wyrIh/o0g8NWacFq4pJBtzUh3w+XSJCEP104lOvDMM3 isystems\stuecking@Samuel-L13
__ALLE-KEYS__

# CONFIG
cat /proc/sys/vm/swappiness && sysctl vm.swappiness=0 && swapoff -a && sysctl vm.swappiness=0 && swapon -a
cat << EOF > /etc/sysctl.conf
net.ipv4.ip_forward = 1  # tailscale
#vm.swappiness      = 60 # default
#vm.swappiness      = 10 # enough
 vm.swappiness      = 0  # low
EOF
sysctl -p /etc/sysctl.conf
#https://pve.proxmox.com/wiki/ZFS_on_Linux#zfs_swap
cat << EOF > /etc/sysctl.d/disable-ipv6.conf
net.ipv6.conf.all.disable_ipv6 = 1     #ipv6 not needed
net.ipv6.conf.default.disable_ipv6 = 1 #ipv6 not needed
EOF
sysctl -p /etc/sysctl.d/disable-ipv6.conf

# UPDATES
wget https://pkgs.tailscale.com/stable/debian/bullseye.gpg && apt-key add bullseye.gpg && rm bullseye.gpg
rm /etc/apt/sources.list.d/*
cat << EOF > /etc/apt/sources.list.d/pve-no-subscription.list
deb http://download.proxmox.com/debian/pve bullseye pve-no-subscription
deb http://download.proxmox.com/debian/pbs bullseye pbs-no-subscription
deb https://pkgs.tailscale.com/stable/debian bullseye main
EOF
apt update -y && apt upgrade -y && apt auto-clean -y

apt update && apt install -y systemd-timesyncd
cat << EOF > /etc/systemd/timesyncd.conf
[Time]
NTP=134.130.4.17
FallbackNTP=134.130.5.17
RootDistanceMaxSec=5
PollIntervalMinSec=32
PollIntervalMaxSec=2048
EOF
systemctl restart systemd-timesyncd

# NAG
echo "DPkg::Post-Invoke { \"dpkg -V proxmox-widget-toolkit | grep -q '/proxmoxlib\.js$'; if [ \$? -eq 1 ]; then { echo 'Removing subscription nag from UI...'; sed -i '/data.status/{s/\!//;s/Active/NoMoreNagging/}' /usr/share/javascript/proxmox-widget-toolkit/proxmoxlib.js; }; fi\"; };" > /etc/apt/apt.conf.d/no-nag-script && apt --reinstall install proxmox-widget-toolkit
sed -i.bak "s/data.status !== 'Active'/false/g" /usr/share/javascript/proxmox-widget-toolkit/proxmoxlib.js && systemctl restart pveproxy.service

# PACKAGES
apt update && apt install -y nfs-kernel-server mdadm parted screen ifupdown2 iftop proxmox-backup-server fio iotop lshw cloud-guest-utils gnupg2 ethtool tailscale sudo zfsutils zfs-initramfs pve-zsync zfs-zed sshfs unzip git jq #postfix-pcre libsasl2-modules
rm /etc/apt/sources.list.d/*enterprise*
apt auto-clean -y && reboot

# VARS
pName="pve"
pTail="kluthe-part"
pBack="pbs"
pMgmt="xcc"
pNumb="1k"
pData="ssd"

# INTERFACES
ip link show
nic=eno1
ethtool $nic
ethtool -i $nic
ethtool -S $nic
ethtool -p $nic 6

# TAILSCALE
hostname="$pName$pNumb-$pTail";routes="172.17.1.0/24,172.17.10.0/24";authkey="tskey-b12beb40c36a8a4530ef0422";
systemctl enable --now tailscaled;sleep 3;tailscale up --authkey=$authkey --hostname=$hostname --advertise-routes="$routes" --accept-routes=false --accept-dns=false
#disable key expiry #do not enable subnet routes

cp /etc/hosts /etc/hosts.bak && cat << EOF > /etc/hosts
127.0.0.1     localhost.localdomain localhost
172.28.100.100 pbs01-zfs2
#MGMT
172.17.10.2   xcc1k
172.17.10.3   xcc2k
172.17.10.4   xcc3k
172.17.10.5   xcc4k
172.17.10.6   xcc5k
172.17.10.7   xcc6k
172.17.10.8   xcc7k
172.17.10.11  pve1k
172.17.10.12  pve2k
172.17.10.13  pve3k
172.17.10.14  pve4k
172.17.10.15  pve5k
172.17.10.16  pve6k
172.17.10.17  pve7k
172.17.10.43  dsm1
172.17.10.44  dsm2
172.17.10.48  pbs1
172.17.10.49  pbs2
172.17.10.51  pbs1k
172.17.10.52  pbs2k
172.17.10.53  pbs3k
172.17.10.54  pbs4k
172.17.10.55  pbs5k
172.17.10.56  pbs6k
172.17.10.57  pbs7k
172.17.10.30  kluthesan01
172.17.10.20  kluthesan02
172.17.10.100 kluthesan03
172.17.10.73  aruba292021
172.17.10.74  aruba292022
172.17.10.93  aruba381021
172.17.10.94  aruba381022
172.17.10.96  aruba292031
172.17.10.97  aruba292032
172.17.10.98  aruba381031
172.17.10.99  aruba381032
#VM
#172.17.1.33  dsm110g
#172.17.1.34  dsm210g
#BAK_ISYSTEMS
10.191.1.6    dsm1bak
#ISCSI
10.59.0.11    iscsi1k1
10.59.0.12    iscsi2k1
10.59.0.13    iscsi3k1
10.59.0.14    iscsi4k1
10.59.0.15    iscsi5k1
10.59.0.16    iscsi6k1
10.59.0.17    iscsi7k1
10.60.0.11    iscsi1k2
10.60.0.12    iscsi2k2
10.60.0.13    iscsi3k2
10.60.0.14    iscsi4k2
10.60.0.15    iscsi5k2
#10.60.0.16   iscsi6k2 #does not have 2nd card
#10.60.0.17   iscsi7k2 #does not have 2nd card
10.59.0.30    kluthesan011a
10.60.0.30    kluthesan011b
10.59.0.31    kluthesan012a
10.60.0.31    kluthesan012b
10.59.0.20    kluthesan021a
10.60.0.20    kluthesan021b
10.59.0.22    kluthesan022a
10.60.0.21    kluthesan022b
10.59.0.100   kluthesan031a
10.60.0.100   kluthesan031b
10.59.0.101   kluthesan032a
10.60.0.101   kluthesan032b
EOF

# SNMP
rm /etc/apt/sources.list.d/*enterprise*
wget https://raw.githubusercontent.com/librenms/librenms-agent/master/agent-local/proxmox -O /usr/local/bin/proxmox && chmod +x /usr/local/bin/proxmox && apt-get update && apt-get -y install snmpd libpve-apiclient-perl && mv /etc/snmp/snmpd.conf /etc/snmp/snmpd.conf.backup
cat << EOF > /etc/snmp/snmpd.conf
rocommunity public 172.17.10.0/24
syslocation  "rack"
syscontact  "sysmessages@isystems-integration.com"
agentAddress  udp:161
agentuser root
dontLogTCPWrappersConnects yes
realStorageUnits 0
extend proxmox /usr/local/bin/proxmox
# snmp ALL=(ALL) NOPASSWD: /usr/local/bin/proxmox
EOF
service snmpd restart && systemctl enable snmpd && update-rc.d snmpd enable

# SCREEN
cat << EOF > ~/.screenrc
startup_message off
vbell off
defscrollback 10000
hardstatus alwayslastline
hardstatus string '%{= kG}[ %{G}%H %{g}][%= %{= kw}%?%-Lw%?%{r}(%{W}%n*%f%t%?(%u)%?%{r})%{w}%?%+Lw%?%?%= %{g}][%{B} %m-%d %{W}%c %{g}]'
termcapinfo xterm* ti@:te@
EOF

# PVEKCLEAN
cd /tmp
git clone https://github.com/jordanhillis/pvekclean.git
cd pvekclean
chmod +x pvekclean.sh
./pvekclean.sh
pvekclean

# STORCLI
cd /tmp
wget https://files.jezz.systems/etc/storcli.deb
dpkg --install storcli.deb
ln -s /opt/MegaRAID/storcli/storcli64 /usr/local/sbin/storcli
storcli show
storcli /c0 show
storcli /c0 /e134 show
storcli /c0 /e134 /s8 show
storcli /c0 /e134 /s8-13 show
storcli /c0 /fall delete
storcli /c0 /e134 /s8-13 set good force
storcli /c0 /e134 /s8-13 set jbod force

# MISC
#lvremove /dev/pve/data entfernt local-lvm: https://docs.linuxmuster.net/de/latest/getting-started/installoptions/install-on-proxmox/
#https://www.osarea.com/zfs-storage-server-setup-zfs-in-proxmox-from-command-line-with-l2arc-and-log-on-ssd
#https://pve.proxmox.com/wiki/Nested_Virtualization
echo "options kvm-intel nested=Y" > /etc/modprobe.d/kvm-intel.conf && modprobe -r kvm_intel

# ROOT
lvdisplay
# If for example we want to resize pve-data to be 10GB and gave pve-root all the other size we can do it by this commands
# remove pve-data logical volume.
lvremove /dev/pve/data -y
# create it again with new size.
lvcreate -L 24G -n data pve -T
# give pve-root all the other size.
lvresize -l +100%FREE /dev/pve/root
# resize pve-root file system
#resize2fs /dev/mapper/pve-root
xfs_growfs /

# UPDATES
apt update && apt upgrade -y && apt auto-clean -y && apt autoremove -y

# NETWORKING
vmbr0="172.17.10.11/24"
vmbr1="172.17.10.51/24" ;     gw="172.17.10.1" 
vmbr2="10.59.0.11/24"   ; iscsi1="iscsi1k1"
vmbr3="10.60.0.11/24"   ; iscsi2="iscsi1k1"

cp /etc/network/interfaces /etc/network/interfaces.bak && cat << EOF > /etc/network/interfaces
auto lo
iface lo inet loopback

auto eno1
iface eno1 inet manual
#bond0

auto eno2
iface eno2 inet manual
#bond0

auto eno3
iface eno3 inet manual
#bond1

auto eno4
iface eno4 inet manual
#bond1

auto ens5f0
iface ens5f0 inet manual
#bond2

auto ens5f1
iface ens5f1 inet manual
#bond2

auto ens6f0
iface ens6f0 inet manual
#bond3

auto ens6f1
iface ens6f1 inet manual
#bond3

auto bond0
iface bond0 inet manual
        bond-slaves eno1 eno2
        bond-miimon 100
        bond-mode active-backup
        bond-primary eno1
#cluster1

auto bond1
iface bond1 inet manual
        bond-slaves eno3 eno4
        bond-miimon 100
        bond-mode active-backup
        bond-primary eno3
#cluster2

auto bond2
iface bond2 inet manual
        bond-slaves ens5f0 ens5f1
        bond-miimon 100
        bond-mode active-backup
        bond-primary ens5f0
#iscsi1

auto bond3
iface bond3 inet manual
        bond-slaves ens6f0 ens6f1
        bond-miimon 100
        bond-mode active-backup
        bond-primary ens6f0
#iscsi2

auto vmbr0
iface vmbr0 inet static
        address $vmbr0
        bridge-ports bond0
        bridge-stp off
        bridge-fd 0
        bridge-vlan-aware yes
        bridge-vids 2-4094
#vm

auto vmbr1
iface vmbr1 inet static
        address $vmbr1
        gateway $gw
        bridge-ports bond1
        bridge-stp off
        bridge-fd 0
        bridge-vlan-aware yes
        bridge-vids 2-4094
#bak

auto vmbr2
iface vmbr2 inet static
        address $vmbr2
        bridge-ports bond2
        bridge-stp off
        bridge-fd 0
        bridge-vlan-aware yes
        bridge-vids 2-4094
        mtu 9000
#$iscsi1

auto vmbr3
iface vmbr3 inet static
        address $vmbr3
        bridge-ports bond3
        bridge-stp off
        bridge-fd 0
        bridge-vlan-aware yes
        bridge-vids 2-4094
        mtu 9000
#$iscsi2

auto vmbr99
iface vmbr99 inet manual
        bridge-ports none
        bridge-stp off
        bridge-fd 0
#internal

EOF

# ADD RAID5 #ssd 8x2tb raid5
##lsblk
#dev=sda
##fdisk /dev/$dev
#parted /dev/$dev --script -- mklabel gpt
#mkfs.xfs /dev/$dev -f
##parted /dev/$dev --script -- mkpart $pData 0% 100%
#blkid | grep $dev
#uuid="89bba9c9-74eb-4ec5-830a-045c85326c28"
#mount="/mnt/$pData"
#mkdir -p "$mount/$pName"
#mkdir -p "$mount/$pBack"
#fstab="UUID=$uuid $mount xfs defaults 0 1";cp /etc/fstab /etc/fstab.bak;echo "$fstab">>/etc/fstab;cat /etc/fstab;
#mount -a;df -h;

# PVE

#pve=$pName$pNumb$pData;echo $pve;
#pvesm add dir $pve --path $mount/pve
#pvesm set $pve --content images,rootdir,vztmpl,backup,iso,snippets
#pvesm set $pve --prune-backups keep-last=3

#https://pve.proxmox.com/wiki/Storage#_using_the_command_line_interface

# PBS
##create datastore on ONE disk/volume #https://pbs.proxmox.com/docs/command-syntax.html#proxmox-backup-manager
#pbs=$pBack$pNumb$pData;echo $pbs;
#pbsFingerprint=$(proxmox-backup-manager cert info | grep Fingerprint);pbsFingerprint=$(echo $pbsFingerprint | awk '{print substr($0,23)}');echo $pbsFingerprint
##create datastore
#proxmox-backup-manager datastore create "$pbs" "$mount/pbs" --keep-daily=7 --keep-weekly=8 --keep-monthly=12 --keep-yearly=3 --verify-new=true --gc-schedule="16:45" --prune-schedule="17:15"
#proxmox-backup-manager datastore list
##remove datastore
##proxmox-backup-manager datastore remove "$pbs"
##add datastore
#pvesm add pbs "$pbs" --server "$pBack$pNumb" --datastore "$pbs" --username "root@pam" --fingerprint "$pbsFingerprint" --password
##set retention in pbs server and keep all in pve datacenter
#pvesm set "$pbs" --prune-backups keep-all=1

# remove local storage
#pvesm status
#pvesm list local
#pvesm list local --iso
pvesm set  local --disable 1
#pvesm list   local-lvm
pvesm remove local-lvm
#add sftp dump and iso
#mkdir -p /mnt/sftp
#pvesm add dir sftp --path /mnt/sftp
#pvesm set sftp --content backup,iso
#pvesm set sftp --prune-backups keep-all=1
#mount -t cifs -o username="administrator",password="",domain="192.168.191.23" "//192.168.191.23/c$/Transfer/isystems/vmware/iso/dump" /mnt/sftp/dump
#mount -t cifs -o username="administrator",password="",domain="192.168.191.23" "//192.168.191.23/c$/Transfer/isystems/vmware/iso"      /mnt/sftp/template/iso
#umount /mnt/sftp/dump && umount /mnt/sftp/template/iso
#pvesm set sftp --disable 1

# BACKUP CONFIG (https://github.com/DerDanilo/proxmox-stuff)
export BACK_DIR="/root/prox_config_backup";mkdir $BACK_DIR;chmod -R 777 $BACK_DIR;
cd /root/ && wget -q -O /root/prox_config_backup.sh  https://raw.githubusercontent.com/DerDanilo/proxmox-stuff/master/prox_config_backup.sh
chmod +x /root/prox_config_backup.sh
./prox_config_backup.sh

# CLEAN
cd /var/log/pve/tasks
rm -f active index */UPID*
systemctl restart pve-cluster
echo >/root/.bash_history
history -c

# ZFS

## USAGE
free -m
awk '/^size/ { print $1 " " $3 / 1048576 }' < /proc/spl/kstat/zfs/arcstats
#https://superuser.com/a/1137417

## INFO

modinfo zfs
zpool status
zpool status -v
pveperf /zfs
arc_summary
cat /proc/spl/kstat/zfs/arcstats
zfs   get all zfs
zpool get all zfs
zpool iostat
zpool iostat -v

# KERNEL

grep Huge /proc/meminfo
cat /sys/kernel/mm/transparent_hugepage/enabled
cp /etc/default/grub /etc/default/grub.bak
cat /etc/default/grub
sed -i 's/GRUB_CMDLINE_LINUX_DEFAULT="quiet"/GRUB_CMDLINE_LINUX_DEFAULT="transparent_hugepage=never"/g' /etc/default/grub
update-grub && update-initramfs -u -k all

## CONF

#https://openzfs.github.io/openzfs-docs/Performance%20and%20Tuning/Module%20Parameters.html?highlight=txg#zfs-module-parameters-1
#https://openzfs.github.io/openzfs-docs/search.html?q=

conf="/etc/modprobe.d/zfs.conf";op="options zfs";cat $conf;
zfs_arc_min=8                     ;((zfs_arc_min=$zfs_arc_min*1024*1024*1024))                      ;zfs_arc_min="$op zfs_arc_min=$zfs_arc_min"                                 ;echo $zfs_arc_min >$conf;
zfs_arc_max=32                    ;((zfs_arc_max=$zfs_arc_max*1024*1024*1024))                      ;zfs_arc_max="$op zfs_arc_max=$zfs_arc_max"                                 ;echo $zfs_arc_max>>$conf;
zfs_dirty_data_max=2              ;((zfs_dirty_data_max=$zfs_dirty_data_max*1024*1024*1024))        ;zfs_dirty_data_max="$op zfs_dirty_data_max=$zfs_dirty_data_max"            ;echo $zfs_dirty_data_max>>$conf;
zfs_dirty_data_max_max=4          ;((zfs_dirty_data_max_max=$zfs_dirty_data_max_max*1024*1024*1024));zfs_dirty_data_max_max="$op zfs_dirty_data_max_max=$zfs_dirty_data_max_max";echo $zfs_dirty_data_max_max>>$conf;
zfs_dirty_data_max_max_percent=25 ;echo "$op ""zfs_dirty_data_max_max_percent=""$zfs_dirty_data_max_max_percent">>$conf;
zfs_dirty_data_max_percent=10     ;echo "$op ""zfs_dirty_data_max_percent=""$zfs_dirty_data_max_percent">>$conf;
zfs_dirty_data_sync_percent=20    ;echo "$op ""zfs_dirty_data_sync_percent=""$zfs_dirty_data_sync_percent">>$conf;
zfs_arc_dnode_limit=0             ;echo "$op ""zfs_arc_dnode_limit=""$zfs_arc_dnode_limit">>$conf;
zfs_arc_dnode_limit_percent=50    ;echo "$op ""zfs_arc_dnode_limit_percent=""$zfs_arc_dnode_limit_percent">>$conf;
zfs_arc_meta_limit=0              ;echo "$op ""zfs_arc_meta_limit=""$zfs_arc_meta_limit">>$conf;
zfs_arc_meta_limit_percent=95     ;echo "$op ""zfs_arc_meta_limit_percent=""$zfs_arc_meta_limit_percent">>$conf;
zfs_prefetch_disable=1            ;echo "$op ""zfs_prefetch_disable=""$zfs_prefetch_disable">>$conf;
zfs_nocacheflush=1                ;echo "$op ""zfs_nocacheflush=""$zfs_nocacheflush">>$conf;
zfs_vdev_sync_write_min_active=8  ;echo "$op ""zfs_vdev_sync_write_min_active=""$zfs_vdev_sync_write_min_active">>$conf;
zfs_vdev_sync_write_max_active=32 ;echo "$op ""zfs_vdev_sync_write_max_active=""$zfs_vdev_sync_write_max_active">>$conf;
zfs_vdev_sync_read_min_active=8   ;echo "$op ""zfs_vdev_sync_read_min_active=""$zfs_vdev_sync_read_min_active">>$conf;
zfs_vdev_sync_read_max_active=32  ;echo "$op ""zfs_vdev_sync_read_max_active=""$zfs_vdev_sync_read_max_active">>$conf;
zfs_vdev_async_read_min_active=8  ;echo "$op ""zfs_vdev_async_read_min_active=""$zfs_vdev_async_read_min_active">>$conf;
zfs_vdev_async_read_max_active=32 ;echo "$op ""zfs_vdev_async_read_max_active=""$zfs_vdev_async_read_max_active">>$conf;
zfs_vdev_async_write_min_active=8 ;echo "$op ""zfs_vdev_async_write_min_active=""$zfs_vdev_async_write_min_active">>$conf;
zfs_vdev_async_write_max_active=32;echo "$op ""zfs_vdev_async_write_max_active=""$zfs_vdev_async_write_max_active">>$conf;
zfs_txg_timeout=5                 ;echo "$op ""zfs_txg_timeout=""$zfs_txg_timeout">>$conf;

cat $conf;
update-grub && update-initramfs -u -k all;
reboot

## DISKS

storcli /c0 /eall /s8-13 show
storcli /c0 /eall /s8-13 show all | egrep 'Device attributes|SN = ' | grep SN

--------------------------------------------------------------------------------------
EID:Slt DID State DG     Size Intf Med SED PI SeSz Model                      Sp SN
--------------------------------------------------------------------------------------
134:8    18 UGood -  1.745 TB SATA SSD Y   N  512B SAMSUNG MZ7L31T9HBLT-00A07 U  S6ESNG0TB01973
134:9    16 UGood -  1.745 TB SATA SSD Y   N  512B SAMSUNG MZ7L31T9HBLT-00A07 U  S6ESNG0TB02005
134:10   20 UGood -  1.745 TB SATA SSD Y   N  512B SAMSUNG MZ7L31T9HBLT-00A07 U  S6ESNG0TB01995
134:11   21 UGood -  1.745 TB SATA SSD Y   N  512B SAMSUNG MZ7L31T9HBLT-00A07 U  S6ESNG0TB01999
134:12   17 UGood -  1.745 TB SATA SSD Y   N  512B SAMSUNG MZ7L31T9HBLT-00A07 U  S6ESNG0TB01996
134:13   19 UGood -  1.745 TB SATA SSD Y   N  512B SAMSUNG MZ7L31T9HBLT-00A07 U  S6ESNG0TB01992
--------------------------------------------------------------------------------------

N=8 ;STRING=$(storcli /c0 /eall /s$N show all | egrep 'Device attributes|SN = ' | grep SN);SN=${STRING#"SN = "};SN08=$(echo $SN);echo "SN ""$N"""="$SN";
N=9 ;STRING=$(storcli /c0 /eall /s$N show all | egrep 'Device attributes|SN = ' | grep SN);SN=${STRING#"SN = "};SN09=$(echo $SN);echo "SN ""$N"""="$SN";
N=10;STRING=$(storcli /c0 /eall /s$N show all | egrep 'Device attributes|SN = ' | grep SN);SN=${STRING#"SN = "};SN10=$(echo $SN);echo "SN""$N"""="$SN";
N=11;STRING=$(storcli /c0 /eall /s$N show all | egrep 'Device attributes|SN = ' | grep SN);SN=${STRING#"SN = "};SN11=$(echo $SN);echo "SN""$N"""="$SN";
N=12;STRING=$(storcli /c0 /eall /s$N show all | egrep 'Device attributes|SN = ' | grep SN);SN=${STRING#"SN = "};SN12=$(echo $SN);echo "SN""$N"""="$SN";
N=13;STRING=$(storcli /c0 /eall /s$N show all | egrep 'Device attributes|SN = ' | grep SN);SN=${STRING#"SN = "};SN13=$(echo $SN);echo "SN""$N"""="$SN";

#SN8=S6ESNG0TB01973
#SN9=S6ESNG0TB02005
#SN10=S6ESNG0TB01995
#SN11=S6ESNG0TB01999
#SN12=S6ESNG0TB01996
#SN13=S6ESNG0TB01992

PREFIX="ata-SAMSUNG_MZ7L31T9HBLT-00A07"
TYPE=SSD
vDEV=/etc/zfs/vdev_id.conf
ls -lah /dev/disk/by-id | grep $PREFIX
cp $vDEV $vDEV.bak
rm $vDEV
NUM=08;SN=$SN08;ID=973;DISK="/dev/disk/by-id/$PREFIX""_""$SN";DISK08=$DISK;VDEV="alias ""$TYPE""_""$NUM""_SA_""$ID"" $DISK""-part1";echo $VDEV>>$vDEV;#echo DISK:$DISK;echo VDEV:$VDEV;
NUM=09;SN=$SN09;ID=005;DISK="/dev/disk/by-id/$PREFIX""_""$SN";DISK09=$DISK;VDEV="alias ""$TYPE""_""$NUM""_SA_""$ID"" $DISK""-part1";echo $VDEV>>$vDEV;#echo DISK:$DISK;echo VDEV:$VDEV;
NUM=10;SN=$SN10;ID=995;DISK="/dev/disk/by-id/$PREFIX""_""$SN";DISK10=$DISK;VDEV="alias ""$TYPE""_""$NUM""_SA_""$ID"" $DISK""-part1";echo $VDEV>>$vDEV;#echo DISK:$DISK;echo VDEV:$VDEV;
NUM=11;SN=$SN11;ID=999;DISK="/dev/disk/by-id/$PREFIX""_""$SN";DISK11=$DISK;VDEV="alias ""$TYPE""_""$NUM""_SA_""$ID"" $DISK""-part1";echo $VDEV>>$vDEV;#echo DISK:$DISK;echo VDEV:$VDEV;
NUM=12;SN=$SN12;ID=996;DISK="/dev/disk/by-id/$PREFIX""_""$SN";DISK12=$DISK;VDEV="alias ""$TYPE""_""$NUM""_SA_""$ID"" $DISK""-part1";echo $VDEV>>$vDEV;#echo DISK:$DISK;echo VDEV:$VDEV;
NUM=13;SN=$SN13;ID=992;DISK="/dev/disk/by-id/$PREFIX""_""$SN";DISK13=$DISK;VDEV="alias ""$TYPE""_""$NUM""_SA_""$ID"" $DISK""-part1";echo $VDEV>>$vDEV;#echo DISK:$DISK;echo VDEV:$VDEV;
cat $vDEV
udevadm trigger

## PARTITION

parted $DISK08 --script -- mklabel gpt
parted $DISK09 --script -- mklabel gpt
parted $DISK10 --script -- mklabel gpt
parted $DISK11 --script -- mklabel gpt
parted $DISK12 --script -- mklabel gpt
parted $DISK13 --script -- mklabel gpt

## POOL
pool=zfs1
 zpool create -f $pool -o ashift=12 -o autotrim=on \
 mirror $DISK08 \
		$DISK09 \
 mirror $DISK10 \
		$DISK11 \
 mirror $DISK12 \
		$DISK13 ;
zfs get recordsize,xattr,compression,sync,atime,relatime,dedup,logbias,primarycache,secondarycache $pool #pool=zfs; zpool create -f $pool -o ashift=0 -o xattr=on -o sync=standard -o compression=off -o atime=on  -o relatime=off -o recordsize=128K dedup=off -o logbias=latency -o primarycache=all -o secondarycache=all -o keyformat=none -o sharesmb=off -o sharenfs=off -o mountpoint=/zfs -o altroot= \

 pveperf /$pool
 zfs set recordsize=128K       $pool
 zfs set xattr=sa              $pool
 zfs set sync=disabled         $pool
 zfs set compression=lz4       $pool
 zfs set atime=off             $pool
 zfs set relatime=on           $pool
 zfs set dedup=off             $pool
 zfs set logbias=throughput    $pool
 zfs set primarycache=metadata $pool
 zfs set secondarycache=none   $pool
#zfs set sharesmb=off          $pool
#zfs set sharenfs=off          $pool
#zfs set volblocksize=16K      $pool
#zfs set keyformat=raw         $pool
pveperf /$pool
zpool set autotrim=on             $pool
zpool export                      $pool
zpool import -d /dev/disk/by-vdev $pool
#zpool import -c /etc/$pool/zpool.cache -aN

## STORAGE

#pvesm add zfspool $pool -pool $pool -blocksize 16K -content rootdir,images -mountpoint /$pool -nodes pve1k -sparse 1

#HELP@pveum
pveum <COMMAND> [ARGS] [OPTIONS]
pveum acl delete <path> --roles <string> [OPTIONS]
pveum acl list  [FORMAT_OPTIONS]
pveum acl modify <path> --roles <string> [OPTIONS]
pveum group add <groupid> [OPTIONS]
pveum group delete <groupid>
pveum group list  [FORMAT_OPTIONS]
pveum group modify <groupid> [OPTIONS]
pveum pool add <poolid> [OPTIONS]
pveum pool delete <poolid>
pveum pool list  [FORMAT_OPTIONS]
pveum pool modify <poolid> [OPTIONS]
pveum realm add <realm> --type <string> [OPTIONS]
pveum realm delete <realm>
pveum realm list  [FORMAT_OPTIONS]
pveum realm modify <realm> [OPTIONS]
pveum realm sync <realm> [OPTIONS]
pveum role add <roleid> [OPTIONS]
pveum role delete <roleid>
pveum role list  [FORMAT_OPTIONS]
pveum role modify <roleid> [OPTIONS]
pveum user tfa delete <userid> [OPTIONS]
pveum user token add <userid> <tokenid> [OPTIONS] [FORMAT_OPTIONS]
pveum user token list <userid> [FORMAT_OPTIONS]
pveum user token modify <userid> <tokenid> [OPTIONS] [FORMAT_OPTIONS]
pveum user token remove <userid> <tokenid> [FORMAT_OPTIONS]
pveum user token permissions <userid> <tokenid> [OPTIONS] [FORMAT_OPTIONS]
pveum user permissions [<userid>] [OPTIONS] [FORMAT_OPTIONS]
pveum user add <userid> [OPTIONS]
pveum user delete <userid>
pveum user list  [OPTIONS] [FORMAT_OPTIONS]
pveum user modify <userid> [OPTIONS]
pveum passwd <userid>
pveum ticket <username> [OPTIONS]
pveum help [<extra-args>] [OPTIONS]

#REALM
?

#POOL
pveum pool list
pPart="Esser"
pPdom="hotel-esser.de"
pPool="Partner.""$pPart"
pveum pool add "$pPool" --comment "Partner:$pPart"

#ROLE
pveum role list
pRgrp="Partner.""$pPart"
pRpri="VM.Allocate VM.Config.CDROM VM.Config.CPU VM.Config.Disk VM.Config.Memory VM.Config.Network VM.Config.Options VM.Console VM.Monitor VM.PowerMgmt VM.Snapshot VM.Snapshot.Rollback"
pveum role add "$pRgrp" -privs "$pRpri"

#GROUP
pveum group list
pGrou="Partner.""$pPart"
pveum group add "$pGrou" -comment "Partner:$pPart"

#USER
pveum user list
pUser="michael"
pEmai="$pUser""@""$pPdom"
pEmai=`echo "$pEmai" | awk '{ print tolower($1) }'`
pUser="$pUser""@""pve"
#pUser="$pUser""@""$pPart"".partners"
#pUser=`echo "$pUser" | awk '{ print tolower($1) }'`
pFirs="Michael"
pLast="Esser"
pPass="Change!t123"
pAuth="pve"
echo "[password='""$pPass""']"
pveum user add "$pUser" -email "$pEmai" -enable 1 -expire 0 -firstname "$pFirs" -lastname "$pLast" -groups "$pGrou" -comment "Partner:$pPart" -password "$pPass"

#PERMISSIONS
pveum acl list
pAxxs="/pool/$pPool" #/nodes/pve012 #/storage/zfs #/vms/1021103
pveum acl modify "$pAxxs" --roles "$pRgrp" -propagate 1 -group "$pGrou"
pveum acl modify "$pAxxs" --roles "$pRgrp" -propagate 1 -users "$pUser"

#REMOVE
pveum acl   delete "$pAxxs" --roles "$pRgrp" -users  "$pUser" -propagate 1
pveum acl   delete "$pAxxs" --roles "$pRgrp" -groups "$pGrou" -propagate 1
pveum role  delete "$pRgrp"
pveum user  delete "$pUser"
pveum group delete "$pGrou"
pveum pool  delete "$pPool"

#PVESH 
#https://pve.proxmox.com/pve-docs/api-viewer/index.html
#https://forum.proxmox.com/threads/list-all-vms-in-specific-pool-with-pvesh.103690/
export mypool=""
pvesh get /cluster/resources --type vm --output-format json |jq '.[]'
pvesh get /cluster/resources --type vm --output-format json |jq '.[]|.template,.type,.status,.maxcpu,.vmid,.name,.node,.pool'| tr -d \" | awk 'NR%8{printf "%s ",$0;next;}1' | column -t | sort -k1 -n
export mypool="unirez"
pvesh get /cluster/resources --type vm --output-format json |jq '.[]|select(.pool == env.mypool)'
pvesh get /cluster/resources --type vm --output-format json |jq '.[]|select(.pool == env.mypool)|.template,.type,.status,.maxcpu,.vmid,.name,.node,.pool'| tr -d \" | awk 'NR%8{printf "%s ",$0;next;}1' | column -t | sort -k1 -n
pvesh get /cluster/resources --type vm --output-format json |jq '.[]|select(.pool != env.mypool)|.template,.type,.status,.maxcpu,.vmid,.name,.node,.pool'| tr -d \" | awk 'NR%8{printf "%s ",$0;next;}1' | column -t | sort -k1 -n | grep $mypool
pvesh set /pools/$mypool --vms 17222276,172222559
export mypool="null"
pvesh get /cluster/resources --type vm --output-format json |jq '.[]|.template,.type,.status,.maxcpu,.vmid,.name,.node,.pool'| tr -d \" | awk 'NR%8{printf "%s ",$0;next;}1' | column -t | sort -k5 -n | grep $mypool
pvesh get /cluster/resources --type vm --output-format json |jq '.[]|.pool,.node,.name,.vmid,.status'                        | tr -d \" | awk 'NR%5{printf "%s ",$0;next;}1' | column -t | sort -k2 -n | grep $mypool
pvesh get /cluster/resources --type vm --output-format json |jq '.[]|.pool,.node,.name,.vmid,.status'                        | tr -d \" | awk 'NR%5{printf "%s ",$0;next;}1' | column -t | sort -k3 -n | grep $mypool
pvesh get /cluster/resources --type vm --output-format json |jq '.[]|.pool,.node,.name,.vmid,.status'                        | tr -d \" | awk 'NR%5{printf "%s ",$0;next;}1' | column -t | sort -k4 -n | grep $mypool
pvesh get /cluster/resources --type vm --output-format json |jq '.[]'                                                        | tr -d \" | awk 'NR%3{printf "%s ",$0;next;}1' | column -t | sort -k1 -n | grep $mypool
pvesh get /cluster/resources --type vm --output-format json |jq '.[]|.vmid,.name,.node'                                      | tr -d \" | awk 'NR%3{printf "%s ",$0;next;}1' | column -t | sort -k1 -n
pvesh get /cluster/resources --type vm --output-format json |jq '.[]|select(.pool == env.mypool)|.id'
pvesh get /cluster/resources --type vm --output-format json |jq '.[]|select(.pool == env.mypool)|.vmid,.name,.node'          | tr -d \" | awk 'NR%3{printf "%s ",$0;next;}1' | column -t | sort -k1 -n

