# SSH
#/home/ansible/files/00-all_keys.txt
cat > /root/.ssh/authorized_keys << __ALLE-KEYS__
ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQDiak2aW6hwqeTs4/+oA/y09AXCjjc4EEKTmOaU0AIXY1OMD/syVz4rHV8VLohcE6tmzjzXZDmDuFSY7XnoBrBJR/ZEfCbQFCpaOQ1VZ7Z/BtRagPkjsZxUpeQ6+VQz8VmsCfxI4nhg19OOk2gBv0/hQD1HGmE2Rcu0JL2l4maZJUnCcCYhsb7j+m9B/jissncI59XjBGUSfIgixId0uUbcpW/Ze67HdhcTaImlra5zC+RPdJJSLfrlyRP+G1sDHNaS/fJXk7oLIOHpQo0zifDUkcWcKlWR201WG8pIjmUsoaBuGO69y/KIqR3fJoWArDD3uKzAqkmC2PoZYa5OWhBd root@HCC-02 
ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQCxo9UZTTksrYaTU8UVHIa6wb5+kpywel5j2kSpkYG9ibb+6zOE+VzchRAm03Gtw7Y5CT9VAQdHpCvaZJn2flxb73vU0gO/acKSRIhINz/QO33bYQnN5gX7D53Vy7TlY259/kHfOvIUGq3BF+lYF4wHrOhEbVMwjCJrH2NQfmmsfPtS6prGJba+dh0FV4K4jkX6fD9vxLST7ulbrssUxF9PcGRVmI0FOYVI2YWBZMaJp1QVLo/vwEQbDH4PCMiMOtBX5C6ot7dUgu2H+nmEeu0LWaQh+JYP3jR7yOfFLD6mkVoAkZDLkljEMJxhC21TZpbtgTf9CeTWEVj0qnIxsxml root@HCC-RZL3-01 
ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQDClquILDs6oqokrkNS4WjKt3mh0rBuXM6VOpjKT5WV3cqiogZ8AP7tHQAIYjEPdkqDi9i7nSLEHsYV8t+Lc7W5A5DBeiSG27Fhf5H/RVbXY1TMmoMpnqAHbFVRiOY1rv9gp7j9Vu7uOYSKnVQnH7dra1N4HdBaGo/uuM3mPZCaOgqLl3RBATb0dU8mTW/eznrb69rYK3gw9U1/u0v6SopPLLBMkYQSx/jadr/L7gAIRa9yu+5sngt4jewAsqC4puU7xunjJndKGnWseYcyOzmYub2p5ce7Gia/j1RbPOF3++vwpiZAfi4clny+Ra8fwlgb9TLU+CS3bVBlBUIlfZjd klaus@Lenovo-P310 
ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQC7c2DfsgOCNSrX8GwwudGGMbmSyigGnv6bM4yCXhbE2wnPhBdF02N2JZxa1URgbaT69Q/U+Gnv7GwC0ZnJUixPcz7eNj3/U9uHstwk7FSxBfAot+M8svSE7kSLoFxf3l99QdbHneNa67K4g2pukbwtjmypChGp7X0f/gixa8VmSvGbIrwAYhZyAvXCPYPY+HFnvVz0z2KR4taq2t5gbBdpW/F/ppV4KpNDZDgkFaFSQ1EKFPWGrsetbwE6vWaPwm+JcH08CgL8fbv9JvMJmPCtkOtluIwsPV6eSLpv81v9digDYmbgYufBmrbmaplHhUaps3iA59tZReH+WVOgQHMf root@Lenovo-P310 
ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQCz2BbQyhA75M+goDLoQeQqhqQkyoYduweOxxndza8dPhCoWIF2tZFie0SPae8TFOspQ0OMHrwxCNyWsUomSxYmRi7u24+gAcV19/ZN3USlGObJ1tscx1QIucUJ2iikNuAo8pu5PpHvRBvqQ13ZZvRXidLTRK60UkQMOPhCviNIRLn9kh5iOI6NxAbaiojPaMdyr5SS0ExUX0PBXpdFcYeLXfBNA4RMyNBC3vWGalEMcbTvQ+KtMY55oSg+69+jhGPccuY2MmwNdP1aFpBxhSuyIu/wa/lD//zHSraY0QgxuTFzw1oTWlvXApeFNT3WJydrpc1TnEvJ6EZiMooDhjet klaus@X349m 
ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQCsDPj4VCKj8Aab8QGDdsL2YEL+eBiKiTzBHFgRfxxd485GtVvfYEM7ElnEVEkjFU1rP6VZcSP/k/13vlkfaMHCs1ep2dmYon7UvXiKd6LTEz1thgDL2OdRVDluL5lTPxCF5LM/wQEbrI31cRs/H2g1GE3TUcC2uYtPnoN6ZDAwdqze2sIFqF/HJPOnStGaQk89IFonvetYSBwxLdqzQ9UE4yHA5vC2nplJ5+Lzifn0wdaYikyMMFgU6iHxeJLwYO9IFVzLtuy/hV11NNCczJhZ78B883aPe6Uz7vVH7PrzFYpRhRMfD/v585wHAaD2ifa4QTGZ2v8EP+Bfdx1RkRxp root@X349m 
ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQCfZuhHrytwVj8SbzDWG+aUhxqyyP1szL1jHUqxmH8SIawLrl3aEpwXFFRxn+NeMlKktuHFBzmp07IQJspYQCE15nqJeUkB8LlMKeV7AyfKrPCDUICo1F6CweEaGduR0LKlyIBlI6uzwvdX7xJ8IvvFXXy1SSXJweecxHxkQvtSFS5uC4ba1VJqPoPTLms1+YyTLB1IFrM18qcu4vJsPrILsq2/x1773THQ2uFVfROwwi0S7HbjwKkeZDuqGtwDcn8LZ+tCsO83tSVyRheImIdDNSatQLJu7fFXp8w6w5H/RvLL5K8ihcwGs35xJ90jh6eOPLhbPxiKgrXVXVAgLK2F root@HMC-01 
ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQDBejZNhe/b5G5osjHujDF/I+l27RBKEK4pso73M4JtyBFD0XpsloifA4b0/AF2p9fjV0pf79rfWmRaAeZl+mKALuaGnUc17CjI0omw977pQLhOVXYQDAC4yhUbk63FaIwyQ49WXKTnzbPC2h+LSWK9aOKBejSdibnM2hYMvnSZg69ckFySTNsto6vC4dYGyy/zttERTyLczE2dsSZy2kdytwurB724EiE6vuBHDYgwp796Mjp4FTDXOg9NPEvqBPhlLDPQ3YaV2pZhzn579O2vxM4XUtXqcx5NckgFgdBUnQupFQVMDlyvlf3GAUl7kt1S8dDNeWrRSpxWFaQWeEXx root@dctpa-hcc-01 
ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQDiCpHdqyjOlGLAjEpYqhH+Hdrd71e6gRxJN3h1DWgubK0ygP2oltEaO5isFnsw31K4oQJly86XaxiWpBDGYuDawiUTWS4HpLMBJROqiUo3sGGis6/1hxJdsA5aBo99mnVedqLWSOzaGf3gEBMMpaUlI6IlHrQYbAB8IEd8AklqGb8eOv/0eGqPdBzTbcWQF93O/2RDux09aMfDcNaCT3i0pVGKE9eG4n/KTdp7FkwRwEPIhCwc3+Y8KX7B4PzIGlGIQ+wLUG94ebTtItgV2C65g/iXSM6Njg8nBs+whlO+zxpU4i0wy4KWDdt9GfMJedLgfLClLR9K0I3dSheT339H skamphoff@saskia.local 
ssh-rsa AAAAB3NzaC1yc2EAAAABJQAAAQEAyh9JmipuyW5kk4LsvtxD5aiwYXQYdWAXMgKGJcOHm5XGP4R62nwjvCPS0JuXMQRyvayy9EjKfnZ4BzF0zacDMNwOgZDubMxy0bHt0XKyO1lpKVQJBWBUeAZtzfMceo/NYPX/WC6FlBFI9p5NIsTCU4BkTaLJt3si7z865hkxxzBvv4KpebyWbdCqRcGbohwbgwZQvmWZSiwfBnlfR0vQWleZVDv8HIHrfKxnuYYzeO0LSNcDn4flknVNZhB3ClDjXAZBpqpjST3nvoUOdtvBzEYSutZ9TiEBzXhuHmHKLrwlpX5s448xXsECXDBuK7Tn5W/z6y0cX0z6BtBz1gyrWQ== rsa-key-20181010-michael-notebook 
ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQDDAj5HEdPDycwWXFkOb0A+eS2unzh7ruONNsqqLmDBrxwD25wD7K1bx8gF7HM5bVNzleoWoR5w4vLMwS5bnLAUXwkQ8VevEWruaaFThQpUj9QOIedjVo77j9aEcXaw0X6V/gjX/zSsX6fV+H4M992Y/4GSgrAlP0r5REmc8t6mAidHqe25D1fTgBy2jCYksJmetT7Gy+HCBUp00aJo1BHbqMLvclklfZB6nrEQCxlWjDK9CPfGTxVfF/IA6y1o61QanHQ1i1G2Kf7nZNVpRsv+hnIh8KuKdwz8WRgJp1Nwv8UBINE9VfJOEI7FWPq6/sJxeSXNR3IbjoNJxXcsxDSB root@HCC-MG-01 
ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQDIEJTbMPJbwO4mrllHoshZSEz3TSqkVlAI0d/N1+Jxrwt3E3z98w9kMMc7XkINtN9THBTkmXi2MJorABzLtk6wiDivTfBHTp27BaGkeBYfa9XM6c6I4LSYouiTG3TcGRhd0imtQnTvosGXYJOerrlVcZlBpOz9XEcmjD4Fgfy3n/jRJHkWGgt07f8P+SBEIkeDIsf8DJQ9Bm5Ap04A0JKlJ7NenmBieQNJ0ZKCrfN5L2AdQ1fONBpiet0WnSGqUZnbL7MonwMhLdFusSEbj3eSGOmPxWM9cl9DX2KRqxDwWZfcumBomX01nxyelx9mIPgsFJDRCl43NN+TTUumG/E7 root@dcdus-hcc03
ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABgQCsF9dX9iBJWCgp5NSQFuX0k9+hx69xeRV0h5qVjc4fHJ4Ur61t9ltz2kQIjX9R0HYu1KMoweVBjwNr1cAFIk18XotP5KdR/Xdbpyo1ghcQB5u1HLtdkMCeO0HXNPc02o6ZQ0SGnXXKGI/4umL4iEDaq82yyhRa548BjA+Iio+FJ6kzf/88NkUGoc5UNFTUG7lpQcqyGnlv83jKfH85Psr0j3lyVVHqLT6U++yKurD0LUD7tuhvP29qhSjyuioFtsBotj7haaeQyg4HnTIazGNP/Jz0WCOSyTuNrvj1GlIQK4XzvHglbZi15zMbm3loXA7ryMqIAO2YdwCDKYS9KpccTEf2EWtal1dPBz/m3n8VyeUv7J8HXReVM7+OfM3gNiutf5A4XB7eTLXFwP1AL1Krh2cG/SUVwARcmLGE2PLA+N3xfZ3iQTfONrFaKjB9Y+g7PSh9+Whtf8xX/ytdRo98uUjyejJQgZITIUHQyB2uFpkDe/0Ku8Sjv0RX5ubw+GE= root@hcc-mg-03
ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQDIEJTbMPJbwO4mrllHoshZSEz3TSqkVlAI0d/N1+Jxrwt3E3z98w9kMMc7XkINtN9THBTkmXi2MJorABzLtk6wiDivTfBHTp27BaGkeBYfa9XM6c6I4LSYouiTG3TcGRhd0imtQnTvosGXYJOerrlVcZlBpOz9XEcmjD4Fgfy3n/jRJHkWGgt07f8P+SBEIkeDIsf8DJQ9Bm5Ap04A0JKlJ7NenmBieQNJ0ZKCrfN5L2AdQ1fONBpiet0WnSGqUZnbL7MonwMhLdFusSEbj3eSGOmPxWM9cl9DX2KRqxDwWZfcumBomX01nxyelx9mIPgsFJDRCl43NN+TTUumG/E7 root@dcdus-hcc03
ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQC4EhIIhIf0hyGjDOQMTVWYdcUHqrklNKVX5ldGEg7OJ0SuwWJbZJeAcqgkGVAh7GRchgHC3RrIurITcOQO6Tdpj8Fy7K48oN8AlMd3yAACchuDeXY8ADSSd4mfcsRjdoepif8JMoVATE2fRvyrqHD+KYwppv+zcvb+Dp6kCxDuuwx/3gsUiBlOUQRcQAeK51OQvdxAicxewS95qYFoqVfMNm04zf436XNEyWHo2Fpn/DGzn3m/onBSu5zjcG4xc2LA3yBFmrr0Ba2+1Z0MmZRiCo7JEbK4AjGW68+L8s0h4wyrIh/o0g8NWacFq4pJBtzUh3w+XSJCEP104lOvDMM3 isystems\stuecking@Samuel-L13
__ALLE-KEYS__

# CONFIG
cat /proc/sys/vm/swappiness && sysctl vm.swappiness=0 && swapoff -a && sysctl vm.swappiness=0 && swapon -a
cat << EOF > /etc/sysctl.conf
net.ipv4.ip_forward = 1  # tailscale
#vm.swappiness      = 60 # default
#vm.swappiness      = 10 # enough
 vm.swappiness      = 0  # low
EOF
sysctl -p /etc/sysctl.conf
#https://pve.proxmox.com/wiki/ZFS_on_Linux#zfs_swap
cat << EOF > /etc/sysctl.d/disable-ipv6.conf
net.ipv6.conf.all.disable_ipv6 = 1     #ipv6 not needed
net.ipv6.conf.default.disable_ipv6 = 1 #ipv6 not needed
EOF
sysctl -p /etc/sysctl.d/disable-ipv6.conf

# UPDATES
wget https://pkgs.tailscale.com/stable/debian/bullseye.gpg && apt-key add bullseye.gpg && rm bullseye.gpg
rm /etc/apt/sources.list.d/*
cat << EOF > /etc/apt/sources.list.d/pve-no-subscription.list
deb http://download.proxmox.com/debian/pve bullseye pve-no-subscription
deb http://download.proxmox.com/debian/pbs bullseye pbs-no-subscription
deb https://pkgs.tailscale.com/stable/debian bullseye main
EOF
apt update -y && apt upgrade -y && apt auto-clean -y

apt update && apt install -y systemd-timesyncd
cat << EOF > /etc/systemd/timesyncd.conf
[Time]
NTP=134.130.4.17
FallbackNTP=134.130.5.17
RootDistanceMaxSec=5
PollIntervalMinSec=32
PollIntervalMaxSec=2048
EOF
systemctl restart systemd-timesyncd

# NAG
echo "DPkg::Post-Invoke { \"dpkg -V proxmox-widget-toolkit | grep -q '/proxmoxlib\.js$'; if [ \$? -eq 1 ]; then { echo 'Removing subscription nag from UI...'; sed -i '/data.status/{s/\!//;s/Active/NoMoreNagging/}' /usr/share/javascript/proxmox-widget-toolkit/proxmoxlib.js; }; fi\"; };" > /etc/apt/apt.conf.d/no-nag-script && apt --reinstall install proxmox-widget-toolkit
sed -i.bak "s/data.status !== 'Active'/false/g" /usr/share/javascript/proxmox-widget-toolkit/proxmoxlib.js && systemctl restart pveproxy.service

# PACKAGES
apt update && apt install -y nfs-kernel-server mdadm parted screen ifupdown2 iftop fio iotop lshw cloud-guest-utils gnupg2 ethtool tailscale sudo zfsutils zfs-initramfs pve-zsync zfs-zed sshfs unzip git jq #postfix-pcre libsasl2-modules
rm /etc/apt/sources.list.d/*enterprise*
apt auto-clean -y && reboot

# VARS
pName="pve"
pBack="pbs"
pMgmt="xcc"
pNumb="023"
pData="zfs"

# INTERFACES
ip link show
nic=eno1
ethtool $nic
ethtool -i $nic
ethtool -S $nic
ethtool -p $nic 6

# TAILSCALE
hostname="$pName$pNumb-atlas-at";routes="";authkey="tskey-b12beb40c36a8a4530ef0422";
systemctl enable --now tailscaled;sleep 3;tailscale up --authkey=$authkey --hostname=$hostname --advertise-routes="$routes" --accept-routes=false --accept-dns=false
#disable key expiry #do not enable subnet routes

cp /etc/hosts /etc/hosts.bak && cat << EOF > /etc/hosts
127.0.0.1       localhost.localdomain localhost
192.168.195.87  $pMgmt$pNumb
172.29.100.23  $pName$pNumb
EOF

# SNMP
rm /etc/apt/sources.list.d/*enterprise*
wget https://raw.githubusercontent.com/librenms/librenms-agent/master/agent-local/proxmox -O /usr/local/bin/proxmox && chmod +x /usr/local/bin/proxmox && apt-get update && apt-get -y install snmpd libpve-apiclient-perl && mv /etc/snmp/snmpd.conf /etc/snmp/snmpd.conf.backup
cat << EOF > /etc/snmp/snmpd.conf
rocommunity public 192.168.195.0/24
syslocation  "rack"
syscontact  "sysmessages@isystems-integration.com"
agentAddress  udp:161
agentuser root
dontLogTCPWrappersConnects yes
realStorageUnits 0
extend proxmox /usr/local/bin/proxmox
# snmp ALL=(ALL) NOPASSWD: /usr/local/bin/proxmox
EOF
service snmpd restart && systemctl enable snmpd && update-rc.d snmpd enable

# SCREEN
cat << EOF > ~/.screenrc
startup_message off
vbell off
defscrollback 10000
hardstatus alwayslastline
hardstatus string '%{= kG}[ %{G}%H %{g}][%= %{= kw}%?%-Lw%?%{r}(%{W}%n*%f%t%?(%u)%?%{r})%{w}%?%+Lw%?%?%= %{g}][%{B} %m-%d %{W}%c %{g}]'
termcapinfo xterm* ti@:te@
EOF

# MISC
#lvremove /dev/pve/data entfernt local-lvm: https://docs.linuxmuster.net/de/latest/getting-started/installoptions/install-on-proxmox/
#https://www.osarea.com/zfs-storage-server-setup-zfs-in-proxmox-from-command-line-with-l2arc-and-log-on-ssd
#https://pve.proxmox.com/wiki/Nested_Virtualization
echo "options kvm-intel nested=Y" > /etc/modprobe.d/kvm-intel.conf && modprobe -r kvm_intel

# ROOT
lvdisplay
# If for example we want to resize pve-data to be 10GB and gave pve-root all the other size we can do it by this commands
# remove pve-data logical volume.
lvremove /dev/pve/data -y
# create it again with new size.
lvcreate -L 24G -n data pve -T
# give pve-root all the other size.
lvresize -l +100%FREE /dev/pve/root
# resize pve-root file system
#resize2fs /dev/mapper/pve-root
xfs_growfs /

# UPDATES
apt update && apt upgrade -y && apt auto-clean -y && apt autoremove -y




## CONF 
 
#https://openzfs.github.io/openzfs-docs/Performance%20and%20Tuning/Module%20Parameters.html?highlight=txg#zfs-module-parameters-1 
#https://openzfs.github.io/openzfs-docs/search.html?q= 
 
conf="/etc/modprobe.d/zfs.conf";op="options zfs";cat $conf; 
zfs_arc_min=8                     ;((zfs_arc_min=$zfs_arc_min*1024*1024*1024))                      ;zfs_arc_min="$op zfs_arc_min=$zfs_arc_min"                                 ;echo $zfs_arc_min >$conf; 
zfs_arc_max=32                    ;((zfs_arc_max=$zfs_arc_max*1024*1024*1024))                      ;zfs_arc_max="$op zfs_arc_max=$zfs_arc_max"                                 ;echo $zfs_arc_max>>$conf; 
zfs_dirty_data_max=2              ;((zfs_dirty_data_max=$zfs_dirty_data_max*1024*1024*1024))        ;zfs_dirty_data_max="$op zfs_dirty_data_max=$zfs_dirty_data_max"            ;echo $zfs_dirty_data_max>>$conf; 
zfs_dirty_data_max_max=4          ;((zfs_dirty_data_max_max=$zfs_dirty_data_max_max*1024*1024*1024));zfs_dirty_data_max_max="$op zfs_dirty_data_max_max=$zfs_dirty_data_max_max";echo $zfs_dirty_data_max_max>>$conf; 
zfs_dirty_data_max_max_percent=25 ;echo "$op ""zfs_dirty_data_max_max_percent=""$zfs_dirty_data_max_max_percent">>$conf; 
zfs_dirty_data_max_percent=10     ;echo "$op ""zfs_dirty_data_max_percent=""$zfs_dirty_data_max_percent">>$conf; 
zfs_dirty_data_sync_percent=20    ;echo "$op ""zfs_dirty_data_sync_percent=""$zfs_dirty_data_sync_percent">>$conf; 
zfs_arc_dnode_limit=0             ;echo "$op ""zfs_arc_dnode_limit=""$zfs_arc_dnode_limit">>$conf; 
zfs_arc_dnode_limit_percent=50    ;echo "$op ""zfs_arc_dnode_limit_percent=""$zfs_arc_dnode_limit_percent">>$conf; 
zfs_arc_meta_limit=0              ;echo "$op ""zfs_arc_meta_limit=""$zfs_arc_meta_limit">>$conf; 
zfs_arc_meta_limit_percent=95     ;echo "$op ""zfs_arc_meta_limit_percent=""$zfs_arc_meta_limit_percent">>$conf; 
zfs_prefetch_disable=1            ;echo "$op ""zfs_prefetch_disable=""$zfs_prefetch_disable">>$conf; 
zfs_nocacheflush=1                ;echo "$op ""zfs_nocacheflush=""$zfs_nocacheflush">>$conf; 
zfs_vdev_sync_write_min_active=8  ;echo "$op ""zfs_vdev_sync_write_min_active=""$zfs_vdev_sync_write_min_active">>$conf; 
zfs_vdev_sync_write_max_active=32 ;echo "$op ""zfs_vdev_sync_write_max_active=""$zfs_vdev_sync_write_max_active">>$conf; 
zfs_vdev_sync_read_min_active=8   ;echo "$op ""zfs_vdev_sync_read_min_active=""$zfs_vdev_sync_read_min_active">>$conf; 
zfs_vdev_sync_read_max_active=32  ;echo "$op ""zfs_vdev_sync_read_max_active=""$zfs_vdev_sync_read_max_active">>$conf; 
zfs_vdev_async_read_min_active=8  ;echo "$op ""zfs_vdev_async_read_min_active=""$zfs_vdev_async_read_min_active">>$conf; 
zfs_vdev_async_read_max_active=32 ;echo "$op ""zfs_vdev_async_read_max_active=""$zfs_vdev_async_read_max_active">>$conf; 
zfs_vdev_async_write_min_active=8 ;echo "$op ""zfs_vdev_async_write_min_active=""$zfs_vdev_async_write_min_active">>$conf; 
zfs_vdev_async_write_max_active=32;echo "$op ""zfs_vdev_async_write_max_active=""$zfs_vdev_async_write_max_active">>$conf; 
zfs_txg_timeout=5                 ;echo "$op ""zfs_txg_timeout=""$zfs_txg_timeout">>$conf; 
 
cat $conf; 
update-grub && update-initramfs -u -k all; 
 
## DISKS 
 
SSD_A="/dev/disk/by-id/scsi-35002538b731498b0" 
SSD_B="/dev/disk/by-id/scsi-35002538b731498d0" 
SSD_C="/dev/disk/by-id/scsi-35002538b731498e0" 
SSD_D="/dev/disk/by-id/scsi-35002538b731498f0"
SSD_E="/dev/disk/by-id/scsi-35002538b73149900" 
SSD_F="/dev/disk/by-id/scsi-35002538b73149910"
SSD_G="/dev/disk/by-id/scsi-35002538b73149920" 
SSD_H="/dev/disk/by-id/scsi-35002538b73149940" 


 
cat << EOF > /etc/zfs/vdev_id.conf
alias SSD_A_8b0 scsi-35002538b731498b0-part1 
alias SSD_B_8d0 scsi-35002538b731498d0-part1 
alias SSD_C_8e0 scsi-35002538b731498e0-part1 
alias SSD_D_8f0 scsi-35002538b731498f0-part1
alias SSD_E_900 scsi-35002538b73149900-part1
alias SSD_F_910 scsi-35002538b73149910-part1
alias SSD_G_920 scsi-35002538b73149920-part1
alias SSD_H_940 scsi-35002538b73149940-part1
EOF
 
udevadm trigger 
 
## PARTITION 
 
parted $SSD_A --script -- mklabel gpt 
parted $SSD_B --script -- mklabel gpt 
parted $SSD_C --script -- mklabel gpt 
parted $SSD_D --script -- mklabel gpt 
parted $SSD_E --script -- mklabel gpt 
parted $SSD_F --script -- mklabel gpt 
parted $SSD_G --script -- mklabel gpt 
parted $SSD_H --script -- mklabel gpt 

 
## POOL 
 
pool=zfs 
 zpool create -f $pool -o ashift=12 -o autotrim=on raidz $SSD_A $SSD_B $SSD_C $SSD_D $SSD_E $SSD_F $SSD_G $SSD_H
zfs get recordsize,xattr,compression,sync,atime,relatime,dedup,logbias,primarycache,secondarycache $pool #pool=zfs; zpool create -f $pool -o ashift=0 -o xattr=on -o sync=standard -o compression=off -o atime=on  -o relatime=off -o recordsize=128K dedup=off -o logbias=latency -o primarycache=all -o secondarycache=all -o keyformat=none -o sharesmb=off -o sharenfs=off -o mountpoint=/zfs -o altroot= \ 
 
 pveperf /zfs 
 zfs set recordsize=128K       $pool 
 zfs set xattr=sa              $pool 
 zfs set sync=disabled         $pool 
 zfs set compression=lz4       $pool 
 zfs set atime=off             $pool 
 zfs set relatime=on           $pool 
 zfs set dedup=off             $pool 
 zfs set logbias=throughput    $pool 
 zfs set primarycache=metadata $pool 
 zfs set secondarycache=none   $pool 
#zfs set sharesmb=off          $pool 
#zfs set sharenfs=off          $pool 
#zfs set volblocksize=16K      $pool 
#zfs set keyformat=raw         $pool 
 pveperf /zfs 
 
zpool set autotrim=on             $pool 
zpool export                      $pool 
zpool import -d /dev/disk/by-vdev $pool 
#zpool import -c /etc/$pool/zpool.cache -aN 