cat /etc/default/grub
#GRUB_CMDLINE_LINUX_DEFAULT="quiet"
 GRUB_CMDLINE_LINUX_DEFAULT="transparent_hugepage=never"
update-initramfs -u -k all
grep Huge /proc/meminfo
cat /sys/kernel/mm/transparent_hugepage/enabled

modinfo zfs
arc_summary
cat /proc/spl/kstat/zfs/arcstats

arcSize="$[2+34]"
arcSizeMin="$[$arcSize * 1024*1024*1024 - 1]"
arcSizeMinConf="options zfs zfs_arc_min=$arcSizeMin"
arcSizeMax="$[$arcSize * 1024*1024*1024]"
arcSizeMaxConf="options zfs zfs_arc_max=$arcSizeMax"
dirtySize="$[1+1]"
dirtyMax="$[$dirtySize * 1024*1024*1024]"
dirtyMaxConf="options zfs zfs_dirty_data_max=$dirtyMax"
echo $arcSizeMinConf  >/etc/modprobe.d/zfs.conf
echo $arcSizeMaxConf >>/etc/modprobe.d/zfs.conf
echo $dirtyMaxConf   >>/etc/modprobe.d/zfs.conf
#nano /etc/default/grub
#GRUB_CMDLINE_LINUX_DEFAULT="transparent_hugepage=never"
#update-initramfs -u
update-initramfs -u -k all

#current #1048576
options zfs zfs_arc_min=4294967296    #4
options zfs zfs_arc_max=1236950581248 #32
options zfs zfs_prefetch_disable=0
options zfs zfs_dirty_data_max=2147483648     #2
options zfs zfs_dirty_data_max_max=4294967296 #4
options zfs zfs_dirty_data_max_max_percent=25
options zfs zfs_dirty_data_max_percent=10
options zfs zfs_dirty_data_sync_percent=20

#suggested
options zfs zfs_arc_min=8589934592            #(( zfs_arc_min =  8 * 1024 * 1024 * 1024 ));echo $zfs_arc_min
options zfs zfs_arc_max=106300440567          #(( zfs_arc_max = 99 * 1024 * 1024 * 1024 ));echo $zfs_arc_max
options zfs zfs_prefetch_disable=1
options zfs zfs_nocacheflush=1
options zfs zfs_arc_meta_limit_percent=95
vm.dirty_background_bytes=134217728
vm.dirty_bytes=1073741824

#https://askubuntu.com/questions/228386/how-do-you-apply-performance-tuning-settings-for-native-zfs
vfs.zfs.prefetch_disable="1"
vfs.zfs.txg.timeout="5"
kern.maxvnodes=250000
vfs.zfs.write_limit_override=1073741824
vfs.zfs.arc_min="512M"
vfs.zfs.arc_max="1536M"
vm.kmem_size_max="8G"
vm.kmem_size="6G"
zil_nocacheflush=1
zfs_nocacheflush=1
1048576

#https://lars.timmann.de/wiki/index.php/ZFS_on_Linux#:~:text=settings%20for%20ZFS-,Set%20module%20parameter%20in%20/etc/modprobe.d/zfs.conf,-options%20zfs%20zfs_arc_max
# increase them so scrub/resilver is more quickly at the cost of other work
options zfs zfs_vdev_scrub_min_active=24
options zfs zfs_vdev_scrub_max_active=64
# sync write
options zfs zfs_vdev_sync_write_min_active=8
options zfs zfs_vdev_sync_write_max_active=32
# sync reads (normal)
options zfs zfs_vdev_sync_read_min_active=8
options zfs zfs_vdev_sync_read_max_active=32
# async reads : prefetcher
options zfs zfs_vdev_async_read_min_active=8
options zfs zfs_vdev_async_read_max_active=32
# async write : bulk writes
options zfs zfs_vdev_async_write_min_active=8
options zfs zfs_vdev_async_write_max_active=32
# max write speed to l2arc
# tradeoff between write/read and durability of ssd (?)
# default : 8 * 1024 * 1024
# setting here : 500 * 1024 * 1024
options zfs l2arc_write_max=524288000

options zfs zfs_top_maxinflight=512
options zfs zfs_resilver_min_time_ms=8000
options zfs zfs_resilver_delay=0

#https://wiki.freebsd.org/ZFSTuningGuide#:~:text=to%20FreeBSD%20too.-,General%20Tuning,-There%20are%20some


/proc/sys/vm/dirty_bytes
zpool create -o ashift=12 -o altroot=/mnt -O acltype=posixacl -O canmount=off -O checksum=on -O compression=off -O mountpoint=none -O sharesmb=off -O sharenfs=off -O xattr=sa rpool mirror /dev/disk/by-id/ata-ST4000...-part1 /dev/disk/by-id/ata-ST4000...-part1

pool=zfs
#zpool create $pool -o xattr=sa -o sync=disabled -o compression=lz4 -o atime=off -o relatime=on  -o recordsize=128K dedup=off -o logbias=throughput -o primarycache=metadata -o secondarycache=none -o keyformat=raw  -o sharesmb=off -o sharenfs=off -o mountpoint=none -o altroot=/mnt
 zpool create $pool -o xattr=on -o sync=standard -o compression=off -o atime=on  -o relatime=off -o recordsize=128K dedup=off -o logbias=latency    -o primarycache=all      -o secondarycache=all  -o keyformat=none -o sharesmb=off -o sharenfs=off -o mountpoint=/zfs -o altroot= \
 mirror /dev/disk/by-id/ata-WDC_WDS200T1R0A-68A4W0_22160Y800315 \
		/dev/disk/by-id/ata-WDC_WDS200T1R0A-68A4W0_22160Y800448 \
 mirror /dev/disk/by-id/ata-WDC_WDS200T1R0A-68A4W0_22160Y800696 \
		/dev/disk/by-id/ata-WDC_WDS200T1R0A-68A4W0_22160Y800727 \
 mirror /dev/disk/by-id/ata-WDC_WDS200T1R0A-68A4W0_22160Y800774 \
		/dev/disk/by-id/ata-WDC_WDS200T1R0A-68A4W0_22160Y800890 \
 mirror /dev/disk/by-id/ata-WDC_WDS200T1R0A-68A4W0_22160Y800007 \
		/dev/disk/by-id/ata-WDC_WDS200T1R0A-68A4W0_22160Y800555 \
 mirror /dev/disk/by-id/ata-WDC_WDS200T1R0A-68A4W0_22160Y800643 \
		/dev/disk/by-id/ata-WDC_WDS200T1R0A-68A4W0_22160Y800698 \
 mirror /dev/disk/by-id/ata-WDC_WDS200T1R0A-68A4W0_22160Y800722 \
		/dev/disk/by-id/ata-WDC_WDS200T1R0A-68A4W0_22160Y800863 \
zpool export $pool
zpool import -d /dev/disk/by-vdev $pool
zpool import -c /etc/$pool/zpool.cache -aN

root@pve6k:/tmp# zfs get all
#NAME   PROPERTY                       #VALUE                          SOURCE
zfs get type                           #filesystem                     -
zfs get creation                       #Sun May 15  0:38 2022          -
zfs get used                           #37.4G                          -
zfs get available                      #10.7T                          -
zfs get referenced                     #24K                            -
zfs get compressratio                  #1.00x                          -
zfs get mounted                        #yes                            -
zfs get quota                          #none                           default
zfs get reservation                    #none                           default
zfs get recordsize                     #128K                           default
zfs get mountpoint                     #/zfs                           default
zfs get sharenfs                       #off                            default
zfs get checksum                       #on                             default
zfs get compression                    #off                            default
zfs get atime                          #on                             default
zfs get devices                        #on                             default
zfs get exec                           #on                             default
zfs get setuid                         #on                             default
zfs get readonly                       #off                            default
zfs get zoned                          #off                            default
zfs get snapdir                        #hidden                         default
zfs get aclmode                        #discard                        default
zfs get aclinherit                     #restricted                     default
zfs get createtxg                      #1                              -
zfs get canmount                       #on                             default
zfs get xattr                          #on                             default
zfs get copies                         #1                              default
zfs get version                        #5                              -
zfs get utf8only                       #off                            -
zfs get normalization                  #none                           -
zfs get casesensitivity                #sensitive                      -
zfs get vscan                          #off                            default
zfs get nbmand                         #off                            default
zfs get sharesmb                       #off                            default
zfs get refquota                       #none                           default
zfs get refreservation                 #none                           default
zfs get guid                           #8590805371690416882            -
zfs get primarycache                   #all                            default
zfs get secondarycache                 #all                            default
zfs get usedbysnapshots                #0B                             -
zfs get usedbydataset                  #24K                            -
zfs get usedbychildren                 #37.4G                          -
zfs get usedbyrefreservation           #0B                             -
zfs get logbias                        #latency                        default
zfs get objsetid                       #54                             -
zfs get dedup                          #off                            default
zfs get mlslabel                       #none                           default
zfs get sync                           #standard                       default
zfs get dnodesize                      #legacy                         default
zfs get refcompressratio               #1.00x                          -
zfs get written                        #24K                            -
zfs get logicalused                    #37.2G                          -
zfs get logicalreferenced              #12K                            -
zfs get volmode                        #default                        default
zfs get filesystem_limit               #none                           default
zfs get snapshot_limit                 #none                           default
zfs get filesystem_count               #none                           default
zfs get snapshot_count                 #none                           default
zfs get snapdev                        #hidden                         default
zfs get acltype                        #off                            default
zfs get context                        #none                           default
zfs get fscontext                      #none                           default
zfs get defcontext                     #none                           default
zfs get rootcontext                    #none                           default
zfs get relatime                       #off                            default
zfs get redundant_metadata             #all                            default
zfs get overlay                        #on                             default
zfs get encryption                     #off                            default
zfs get keylocation                    #none                           default
zfs get keyformat                      #none                           default
zfs get pbkdf2iters                    #0                              default
zfs get special_small_blocks           #0                              default
root@pve6k:/tmp# zpool get all
#NAME    PROPERTY                       #VALUE                          SOURCE
zfs get size                           #10.9T                          -
zfs get capacity                       #0%                             -
zfs get altroot                        #-                              default
zfs get health                         #ONLINE                         -
zfs get guid                           #15114501276587986499           -
zfs get version                        #-                              default
zfs get bootfs                         #-                              default
zfs get delegation                     #on                             default
zfs get autoreplace                    #off                            default
zfs get cachefile                      #-                              default
zfs get failmode                       #wait                           default
zfs get listsnapshots                  #off                            default
zfs get autoexpand                     #off                            default
zfs get dedupratio                     #1.00x                          -
zfs get free                           #10.8T                          -
zfs get allocated                      #37.4G                          -
zfs get readonly                       #off                            -
zfs get ashift                         #0                              default
zfs get comment                        #-                              default
zfs get expandsize                     #-                              -
zfs get freeing                        #0                              -
zfs get fragmentation                  #0%                             -
zfs get leaked                         #0                              -
zfs get multihost                      #off                            default
zfs get checkpoint                     #-                              -
zfs get load_guid                      #15143952709872827590           -
zfs get autotrim                       #off                            default
zfs get compatibility                  #off                            default
zfs get feature@async_destroy          #enabled                        local
zfs get feature@empty_bpobj            #active                         local
zfs get feature@lz4_compress           #active                         local
zfs get feature@multi_vdev_crash_dump  #enabled                        local
zfs get feature@spacemap_histogram     #active                         local
zfs get feature@enabled_txg            #active                         local
zfs get feature@hole_birth             #active                         local
zfs get feature@extensible_dataset     #active                         local
zfs get feature@embedded_data          #active                         local
zfs get feature@bookmarks              #enabled                        local
zfs get feature@filesystem_limits      #enabled                        local
zfs get feature@large_blocks           #enabled                        local
zfs get feature@large_dnode            #enabled                        local
zfs get feature@sha512                 #enabled                        local
zfs get feature@skein                  #enabled                        local
zfs get feature@edonr                  #enabled                        local
zfs get feature@userobj_accounting     #active                         local
zfs get feature@encryption             #enabled                        local
zfs get feature@project_quota          #active                         local
zfs get feature@device_removal         #enabled                        local
zfs get feature@obsolete_counts        #enabled                        local
zfs get feature@zpool_checkpoint       #enabled                        local
zfs get feature@spacemap_v2            #active                         local
zfs get feature@allocation_classes     #enabled                        local
zfs get feature@resilver_defer         #enabled                        local
zfs get feature@bookmark_v2            #enabled                        local
zfs get feature@redaction_bookmarks    #enabled                        local
zfs get feature@redacted_datasets      #enabled                        local
zfs get feature@bookmark_written       #enabled                        local
zfs get feature@log_spacemap           #active                         local
zfs get feature@livelist               #enabled                        local
zfs get feature@device_rebuild         #enabled                        local
zfs get feature@zstd_compress          #enabled                        local
zfs get feature@draid                  #enabled                        local
