cls
Get-NetAdapter
$InterfaceIndex            = Read-Host -Prompt 'Input your ifIndex #'
$Ethernet0                 = "docking"
$Ethernet0                 = (Get-NetIPConfiguration    | Where-Object {$_.InterfaceIndex  -eq $InterfaceIndex}).InterfaceAlias
Read-Host -Prompt "You entered '$InterfaceIndex' which corresponds to '$Ethernet0'. Press enter to confirm or ctrl+c to abort."
$InterfaceIndex            = (Get-NetIPConfiguration    | Where-Object {$_.InterfaceIndex -eq $InterfaceIndex}).InterfaceIndex
#Get-NetAdapter -Name $Ethernet0
#Rename-NetAdapter -Name $Ethernet0 -NewName Ethernet0;$Ethernet0="Ethernet0"
###################################################
$NetProfile                = (Get-NetIPConfiguration    | Where-Object {$_.InterfaceAlias -eq $Ethernet0}).NetProfile.Name
$InterfaceAlias            = (Get-NetIPConfiguration    | Where-Object {$_.InterfaceAlias -eq $Ethernet0}).InterfaceAlias
$InterfaceDescription      = (Get-NetIPConfiguration    | Where-Object {$_.InterfaceAlias -eq $Ethernet0}).InterfaceDescription
$InterfaceStatus           = (Get-NetIPConfiguration                      -InterfaceAlias     $Ethernet0 -Detailed).NetAdapter.Status
$InterfaceDhcpEnabled      = (Get-NetIPConfiguration                      -InterfaceAlias     $Ethernet0 -Detailed).NetIPv4Interface.DHCP
$InterfaceCategory         = (Get-NetIPConfiguration                      -InterfaceAlias     $Ethernet0 -Detailed).NetProfile.NetworkCategory 
$InterfaceMacDash          = (Get-NetIPConfiguration                      -InterfaceAlias     $Ethernet0 -Detailed).NetAdapter.LinkLayerAddress
$InterfaceMacColon         = (Get-NetIPConfiguration                      -InterfaceAlias     $Ethernet0 -Detailed).NetAdapter.LinkLayerAddress | % {$_.replace("-",":")}
$InterfaceMacString        = (Get-NetIPConfiguration                      -InterfaceAlias     $Ethernet0 -Detailed).NetAdapter.LinkLayerAddress | % {$_.replace("-","")}
$ComputerName              = (Get-NetIPConfiguration                      -InterfaceAlias     $Ethernet0).ComputerName
$IPAddress                 = (Get-NetIPConfiguration                      -InterfaceAlias     $Ethernet0 | Get-NetIPAddress).IPV4Address
$IPAddressFamily           = (Get-NetIPConfiguration                      -InterfaceAlias     $Ethernet0 | Get-NetIPAddress).AddressFamily
$IPPrefixLength            = (Get-NetIPConfiguration                      -InterfaceAlias     $Ethernet0 | Get-NetIPAddress).PrefixLength
$IPDefaultGateway          = (Get-NetIPConfiguration                      -InterfaceAlias     $Ethernet0 -Detailed).IPv4DefaultGateway | select -ExpandProperty NextHop
$IPDNSServer               = (Get-DnsClientServerAddress                  -InterfaceAlias     $Ethernet0 | Select-Object -ExpandProperty ServerAddresses) -join "','";$IPDNSServer = -join("'", $IPDNSServer, "'")
###################################################
$Settings                  = $PSScriptRoot + '\getNetworkConfig_InterfaceIndex' + '_' + $InterfaceIndex + '.txt'
echo "NetProfile           = $NetProfile          " >  "$Settings"
echo "InterfaceAlias       = $InterfaceAlias      " >> "$Settings"
echo "InterfaceIndex       = $InterfaceIndex      " >> "$Settings"
echo "InterfaceDescription = $InterfaceDescription" >> "$Settings"
echo "InterfaceStatus      = $InterfaceStatus     " >> "$Settings"  
echo "InterfaceDhcpEnabled = $InterfaceDhcpEnabled" >> "$Settings"
echo "InterfaceCategory    = $InterfaceCategory   " >> "$Settings"
echo "InterfaceMacDash     = $InterfaceMacDash    " >> "$Settings"
echo "InterfaceMacColon    = $InterfaceMacColon   " >> "$Settings"
echo "InterfaceMacString   = $InterfaceMacString  " >> "$Settings"
echo "ComputerName         = $ComputerName        " >> "$Settings"
echo "IPAddress            = $IPAddress           " >> "$Settings"
echo "IPAddressFamily      = $IPAddressFamily     " >> "$Settings"
echo "IPPrefixLength       = $IPPrefixLength      " >> "$Settings"
echo "IPDefaultGateway     = $IPDefaultGateway    " >> "$Settings"
echo "IPDNSServer          = $IPDNSServer         " >> "$Settings"
cls
Write-Host "[Settings]"
Get-Content -Raw -Path $Settings 
$Config = $PSScriptRoot + '\getNetworkConfig.txt'
Get-Content -Raw -Path $Settings > $Config
###################################################
$Config = $PSScriptRoot + '\setNetworkConfig.ps1'
echo "#netsh interface ip reset                                                                                                     " >  "$Config"
echo "#Rename-NetAdapter -Name Ethernet -NewName $InterfaceAlias                                                                    " >> "$Config"
echo " Get-NetAdapter -physical | where MacAddress -eq $InterfaceMacDash | Rename-NetAdapter -NewName Ethernet0                     " >> "$Config"
echo " Start-Sleep -Seconds 3                                                                                                       " >> "$Config"
echo " Set-NetIPInterface    -InterfaceAlias $InterfaceAlias -Dhcp Disabled                                                         " >> "$Config"
echo " Get-NetAdapterBinding -InterfaceAlias $InterfaceAlias | Set-NetAdapterBinding -Enabled:0 -ComponentID ms_tcpip6              " >> "$Config"
echo "#Remove-NetIPAddress   -InterfaceAlias $InterfaceAlias                                                                        " >> "$Config"
echo "#Remove-NetRoute       -InterfaceAlias $InterfaceAlias                                                                        " >> "$Config"
echo " New-NetIPAddress      -InterfaceAlias $InterfaceAlias -AddressFamily $IPAddressFamily -IPAddress $IPAddress -PrefixLength $IPPrefixLength -DefaultGateway $IPDefaultGateway" >> "$Config"
echo " Set-DnsClientServerAddress -InterfaceAlias $InterfaceAlias -ServerAddresses $IPDNSServer                                     " >> "$Config"
echo " Clear-DnsClientCache                                                                                                         " >> "$Config"
echo " Set-Itemproperty -Path HKLM:\SYSTEM\CurrentControlSet\Services\tcpip6\Parameters -Name DisabledComponents -value 32          " >> "$Config"
echo " netsh interface teredo set state disabled                                                                                    " >> "$Config"
echo " netsh interface ipv6 6to4 set state state=disabled undoonstop=disabled                                                       " >> "$Config"
echo " netsh interface ipv6 isatap set state state=disabled                                                                         " >> "$Config"
echo "                                                                                                                              " >> "$Config"
###################################################
Read-Host -Prompt "Done. Press enter to exit."

