function SetLanguageAndTimeZone {
    param(
        [Parameter(Mandatory=$true)][string]$Language,
        [Parameter(Mandatory=$true)][string]$TimeZone,
        [Parameter(Mandatory=$true)][string]$PackagePath
    )
    $languagePack = (Find-Package -Name "Microsoft-Windows-Server-Language-Pack_x64_$Language").Name
    if ($languagePack -eq $null) {
        Write-Warning "Language pack for $Language is not installed. Installing now..."
		$url = "https://files.esser.space/iso/Win2019_LPs.zip"
        $zip = "C:\tools\ad\etc\Win2019_LPs.zip"
		$extractTo = "C:\tools\ad\etc\Win2019_LPs" ; if (!(Test-Path -Path $extractTo)) {New-Item -ItemType Directory -Path $extractTo | Out-Null}
		(New-Object Net.WebClient).DownloadFile($url, $zip)
		Expand-Archive -LiteralPath $zip -DestinationPath $extractTo
		Remove-Item -Path $zip
        Add-WindowsPackage -Online -PackagePath "$PackagePath\Microsoft-Windows-Server-Language-Pack_x64_$Language.cab"
    } else {
        Write-Host "Language pack for $Language is already installed."
    }
    Set-WinUILanguageOverride -Language $Language
    Set-WinSystemLocale -SystemLocale $Language
	Set-WinUserLanguageList $Language -Force
    Set-TimeZone -Id $TimeZone
	$users = Get-LocalUser
    foreach ($user in $users) {
        Set-WinSystemLocale -SystemLocale $Language
        Set-WinUserLanguageList $Language -Force
        Set-TimeZone -Id $TimeZone
    }
    New-Item -Type Directory -Path "$env:SystemDrive\Users\Default\AppData\Local\Microsoft\Windows\Shell" -ErrorAction Ignore | Out-Null
    New-Item -Type Directory -Path "$env:SystemDrive\Users\Default\AppData\Local\Microsoft\Windows\Shell\MuiCache" -ErrorAction Ignore | Out-Null
    New-Item -Type Directory -Path "$env:SystemDrive\Users\Default\AppData\Local\Microsoft\Windows\Themes" -ErrorAction Ignore | Out-Null
    New-Item -Type Directory -Path "$env:SystemDrive\Users\Default\AppData\Local\Microsoft\Windows\Themes\TranscodedWallpaper" -ErrorAction Ignore | Out-Null
    Copy-Item "$env:SystemDrive\Windows\SystemResources\Windows.UI.Logon\*" "$env:SystemDrive\Users\Default\AppData\Local\Microsoft\Windows\Themes\TranscodedWallpaper" -Recurse -Force | Out-Null
    Copy-Item "$env:SystemDrive\Windows\SystemResources\Windows.UI.Logon\*" "$env:SystemDrive\Users\Default\AppData\Local\Microsoft\Windows\Shell" -Recurse -Force | Out-Null
    $regLang = [Microsoft.Win32.RegistryKey]::OpenRemoteBaseKey('LocalMachine', '.')
    $regLangKey= $regLang.OpenSubKey("SOFTWARE\Microsoft\Windows NT\CurrentVersion\Winlogon",$True)
    $regLangKey.SetValue("DefaultUserLanguage", "$Language")
    $regLangKey.SetValue("DefaultSystemLanguage", "$Language")
    $regLangKey.Close()
    $regLang.Close()
    #Restart-Computer
}
#SetLanguageAndTimeZone -Language "de-DE" -TimeZone "W. Europe Standard Time" -PackagePath "C:\Users\administrator.DEMO\Downloads\Win2019"