# https://documentation.suse.com/sbp/sap/html/SBP-SLES4SAP-HANAonKVM-SLES15SP2/index.html

# CHECK

#Check kernel boot options used:
cat /proc/cmdline #BOOT_IMAGE=/boot/vmlinuz-5.3.18-150300.59.76-default root=/dev/mapper/system-root splash=silent quiet crashkernel=207M,high crashkernel=72M,low transparent_hugepage=never mitigations=auto
#Check huge page status (This command can also be used to monitor the progress of huge page allocation during VM start):
cat /proc/meminfo | grep Huge
#Checking L3 cache has been enabled in the guest:
lscpu | grep L3
#Validate guest and host CPU topology:
lscpu

# APPLY

cp /etc/default/grub /etc/default/grub.20220705
vi /etc/default/grub
#GRUB_CMDLINE_LINUX_DEFAULT="splash=silent quiet crashkernel=207M,high crashkernel=72M,low transparent_hugepage=never mitigations=auto kvm.nx_huge_pages=off intremap=no_x2apic_optout"
grub2-mkconfig -o /boot/grub2/grub.cfg
zypper in -y vm-dump-metrics sapconf
vm-dump-metrics
systemctl status  irqbalance
systemctl disable irqbalance
systemctl stop    irqbalance
#https://documentation.suse.com/sles-sap/15-SP3/html/SLES-SAP-guide/cha-tune.html
cp /etc/sysconfig/sapconf /etc/sysconfig/sapconf.bak
vi /etc/sysconfig/sapconf #When using sapconf version 5, stop and disable the tuned service and instead enable and start the sapconf service.
cat << EOF > /etc/sysconfig/sapconf
VSZ_TMPFS_PERCENT=75
SHMALL=1152921504606846720
SHMMAX=18446744073709551615
LIMIT_1="@sapsys soft nofile 1048576"
LIMIT_2="@sapsys hard nofile 1048576"
LIMIT_3="@sdba soft nofile 1048576"
LIMIT_4="@sdba hard nofile 1048576"
LIMIT_5="@dba soft nofile 1048576"
LIMIT_6="@dba hard nofile 1048576"
MAX_MAP_COUNT=2147483647
SHMMNI=32768
DIRTY_BYTES=629145600
DIRTY_BG_BYTES=314572800
TCP_SLOW_START=0
KSM=0
NUMA_BALANCING=0
THP=never
PERF_BIAS=performance
GOVERNOR=performance
FORCE_LATENCY=5
MIN_PERF_PCT=100
IO_SCHEDULER="noop none"
EOF
mkinitrd
cat        /sys/devices/system/clocksource/clocksource0/current_clocksource
#kvm-clock
echo tsc > /sys/devices/system/clocksource/clocksource0/current_clocksource
cat     /sys/kernel/mm/ksm/run
0
echo 2 >/sys/kernel/mm/ksm/run

# ONBOOT

#!/usr/bin/env bash
#
# Configure KVM guest for SAP HANA
#
POLL_NS=800000
GROW_START=200000
# disable irqbalance
systemctl disable --now irqbalance
modprobe cpuidle-haltpoll
echo $POLL_NS > /sys/module/haltpoll/parameters/guest_halt_poll_ns
echo $GROW_START > /sys/module/haltpoll/parameters/guest_halt_poll_grow_start
# Set clocksource to tsc
echo tsc > /sys/devices/system/clocksource/clocksource0/current_clocksource
# disable Kernel Samepage Merging
echo 2 >/sys/kernel/mm/ksm/run
# 2: disable it, but make sure you also purify everything with fire!
# fix access to vhostmd device, so that SIDadm can read it
# see function setup_vhostmd_guest_device() in qacss-schwifty-common
# the vhostmd device has exactly 256 blocks, try to catch that from /proc/partitions
VHOSTMD_DEVICE=$(grep "   256 " /proc/partitions | awk '{print $4}' )
if [ -n "$VHOSTMD_DEVICE" ]; then
  chmod o+r /dev/"$VHOSTMD_DEVICE"
else
  echo "Missing vhostmd device, please check you XML file."
fi
