[CmdletBinding(DefaultParameterSetName = 'Default')]
param(
    [Parameter(ParameterSetName = 'NeverExpires')]
    [switch]$NeverExpires,

    [Parameter(ParameterSetName = 'AdminAdd')]
    [switch]$AdminAdd,

    [Parameter(ParameterSetName = 'AdminRemove')]
    [switch]$AdminRemove
)

$ScriptFile = $PSScriptRoot + '\' + [System.IO.Path]::GetFileNameWithoutExtension($($PSCommandPath | Split-Path -Leaf)) + '.ps1'

if ($PSCmdlet.ParameterSetName -eq 'NeverExpires') {
    $userName = "administrator"
    Set-LocalUser -Name $userName -PasswordNeverExpires 1
}
elseif ($PSCmdlet.ParameterSetName -eq 'AdminAdd') {
    $userName = "adminv2p"
    $userPass = "Test1234"
    New-LocalUser -Name $userName -Password (ConvertTo-SecureString $userPass -AsPlainText -Force) -Description "Temporary Admin User"
    Set-LocalUser -Name $userName -PasswordNeverExpires 1
    Add-LocalGroupMember -SID "S-1-5-32-544" -Member $userName
}
elseif ($PSCmdlet.ParameterSetName -eq 'AdminRemove') {
	$userName    = "adminv2p" ; 
	$userName    = Get-LocalUser -Name "$userName" ;
	$profilePath = 'C:\Users\' + "$userName" ;
    $userProfile = Get-CimInstance -Class Win32_UserProfile | Where-Object { $_.LocalPath -eq "$profilePath" } ;
	$userName    | Remove-LocalUser ;
	if (Test-Path "$profilePath") { $userProfile | Remove-CimInstance ; }
}
else {
    Write-Output @"
[Examples to run this script]
$ScriptFile -NeverExpires
$ScriptFile -AdminAdd
$ScriptFile -AdminRemove

"@
}
